#include "PC2119_16X2_LCD.h"
#include <stdarg.h>

void PC2119_16X2_LCD::Init() {
    // reset the LCD using external reset pin
    _reset = 1;
    wait_us(300);
    _reset = 0;
    wait_us(12000);

    char buf[15];
    buf[0] = INSTRUCTION_CTRL_BYTE;
    buf[1] = (FUNCTION_SET | 0x01); // Function set + extended instruction set
    buf[2] = CURSOR_DISLPAY_SHIFT;
    buf[3] = ICON_CTRL;
    buf[4] = VLCD_MULTIPLIER; //set Vlcd multiplier
    buf[5] = VLCD_CONTRAST; //set Vlcd Contrast

    buf[6] = FUNCTION_SET; // basic instructions
    buf[7] = DISPLAY_CTL;
    buf[8] = ENTRY_MODE;
    buf[9] = CLEAR_DISPLAY;

    _i2c.write(LCD_I2C_ADR, buf, 10);
}


PC2119_16X2_LCD::PC2119_16X2_LCD(PinName p_sda, PinName p_scl, PinName p_reset) : _i2c(p_sda, p_scl), _reset(p_reset) {

    PC2119_16X2_LCD::Init();
}

PC2119_16X2_LCD::PC2119_16X2_LCD(I2C& p_i2c, PinName p_reset) : _i2c(p_i2c), _reset(p_reset) {

    PC2119_16X2_LCD::Init();

}

char PC2119_16X2_LCD::ascii_to_lcd(char ch) {
    char c = BLANK_CHAR;  // default: white space

    if ((ch>=' ') & (ch<='?'))
        c = ASCII_OFFSET + ch;
    if ((ch>='A') & (ch<='Z'))
        c = ASCII_OFFSET + ch;
    if ((ch>='a') & (ch<='z'))
        c = ASCII_OFFSET + ch;
    return c;
}

void PC2119_16X2_LCD::write_xy(char c, char row, char column, bool raw) {
    char buf[0x10];
    char adr;

    if (row == 0)                               // line offset
        adr = column;
    else
        adr = DATA_CTRL_BYTE + column;

    buf[0] = INSTRUCTION_CTRL_BYTE;            // Enter function setting
    buf[1] = 0x80 + adr;    // LCD adr counter set to "adr"

    _i2c.write(LCD_I2C_ADR,(char *)buf,2);

    buf[0] = DATA_CTRL_BYTE;            // write to DDRAM
    buf[1] = raw ? c : ascii_to_lcd(c);

    _i2c.write(LCD_I2C_ADR,(char *)buf,2);
}

void PC2119_16X2_LCD::clear_line(char row) {
    if (row == 0 || row == 1) {
        char i=0;
        do
            write_xy(BLANK_CHAR, row, i);
        while ((i++<16));
    }
}

void PC2119_16X2_LCD::clear_display(void) {
    clear_line(0);                // clear 1st line
    clear_line(1);                // clear 2nd line
    return;
}

void PC2119_16X2_LCD::write(char *b) {
    char buf[0x60];
    int a;

    buf[0]=INSTRUCTION_CTRL_BYTE;
    buf[1]=0x80;
    _i2c.write(LCD_I2C_ADR,(char *)buf,2);

    a=0;
    buf[0]=DATA_CTRL_BYTE;

    while (a!=strlen(b)) {
        buf[a+1]=ascii_to_lcd(b[a]);
        a++;
    }
    buf[a+1]=INSTRUCTION_CTRL_BYTE;

    _i2c.write(LCD_I2C_ADR,buf,strlen(b)+1);

    buf[0]=0x80;
    buf[1]=0x02;
    _i2c.write(LCD_I2C_ADR,(char *)buf,2);
}

void PC2119_16X2_LCD::printf(const char * format, ... ) {
    // create and start the va_list
    va_list listPointer ;
    va_start( listPointer, format ) ;

    // vsprintf is an example of
    // a function that works with
    // an "already started" va_list
    static char buf[ 1024 ] ;
    vsprintf( buf, format, listPointer ) ;

    return write(buf);
}

void PC2119_16X2_LCD::flip_display() {
    _i2c.start();
    _i2c.write(LCD_I2C_ADR);
    _i2c.write(INSTRUCTION_CTRL_BYTE);          // Control byte for Instruction
    _i2c.write(FUNCTION_SET | 0x01); // extended instruction mode
    _i2c.write(0x07);          // P=1; Q=1;
    _i2c.write(FUNCTION_SET);
    _i2c.stop();
}

void PC2119_16X2_LCD::unflip_display() {
    _i2c.start();
    _i2c.write(LCD_I2C_ADR);
    _i2c.write(INSTRUCTION_CTRL_BYTE);          // Control byte for Instruction
    _i2c.write(FUNCTION_SET | 0x01);
    _i2c.write(0x04);          // P=0; Q=0;
    _i2c.write(FUNCTION_SET);
    _i2c.stop();
}