#include "mbed.h"
#include "HMC6343.h"

HMC6343 compass(p9, p10);
Serial pc(USBTX, USBRX);

Ticker t;
Ticker t1;
Heading heading;

volatile bool display_values = true;
volatile bool sample_sensor = true;

void do_display_values() {
    display_values = true;
}

void do_sample_sensor() { sample_sensor = true; }

int main() {
    pc.baud(115200);
    t.attach(&do_display_values, 1);
    t1.attach_us(&do_sample_sensor, 100 * 500);
    
    int opMode = compass.getOpMode();
    printf("Op mode %d\r\n", opMode);    
    opMode |= HMC6343_CM_MR_5HZ;
    
    //opMode &= ~HMC6343_STDBY;
    //opMode |= HMC6343_RUN;
    
    printf("Op mode %d\r\n", opMode);
    compass.setOpMode(opMode);

    printf("Op mode %d\r\n", compass.getOpMode());
    
    printf("Compass software version %d\r\n", compass.getSoftwareVersion());
    printf("Compass variation %f \r\n", compass.getMagneticVariation()); 
    printf("Compass measurement rate %d\r\n", compass.getMeasurementRate());   

    //compass.setMagneticVariation(0.52);
    //printf("Compass variation %f \r\n", compass.getMagneticVariation());
    
    printf("IIR Filter : %d\r\n", compass.isOpModeFlagSet(HMC6343_FILTER));    
    printf("IIR Filter bias : %d\r\n", compass.getIIRFilter());

    //compass.setIIRFilter(4);
    //printf("IIR Filter bias : %d\r\n", compass.getIIRFilter());

    // seems a restart is needed for this change to happen in the module
    // compass.setOpMode(opMode &= ~HMC6343_FILTER);
    // printf("IIR Filter : %d\r\n", compass.isOpModeFlagSet(HMC6343_FILTER));        
    
    compass.setReset();
    
    while (1) {
        if (sample_sensor) {
            compass.sampleHeading(&heading);
            sample_sensor = false;
        }

        if (display_values) {
            pc.printf("bearing %3.1f \r\n", heading.heading);
            pc.printf("roll %f \r\n", heading.roll);
            pc.printf("pitch %f \r\n", heading.pitch);
            display_values = false;
        }
    }

}