// skeleton code for ECE 2036 thermostat lab
// code must be added by students
#include "mbed.h"
#include "TMP36.h"
#include "SDFileSystem.h"
#include "uLCD_4DGL.h"
#include "PinDetect.h"
#include "Speaker.h"
#include "RGBLed.h"
// must add your new class code to the project file Shiftbrite.h

enum Statetype { Off, Heat_off , Heat_on , Cool_off , Cool_on };
 //p21,22,24 RGB
//RGBLed myRGBLed(p21,p22,p24);
// use class to setup temperature sensor pins
TMP36 myTMP36(p15);  //Analog in

// use class to setup microSD card filesystem
//SDFileSystem sd(p5, p6, p7, p8, "sd");

// use class to setup the  Color LCD
uLCD_4DGL uLCD(p28, p27, p29); // create a global uLCD object

// use class to setup pushbuttons pins
PinDetect pb1(p25);
PinDetect pb2(p24);//p24
PinDetect pb3(p23);

PinDetect pb4(p22); //p22
// use class to setup speaker pin
Speaker mySpeaker(p21); //PWM out //p21

// use class to setup Shiftbrite pins
//Shiftbrite myShiftbrite(p9, p10, p11, p12, p13);// ei li di n/c ci

// use class to setup Mbed's four on-board LEDs
DigitalOut myLED1(LED1);
DigitalOut myLED2(LED2);
DigitalOut myLED3(LED3);
DigitalOut myLED4(LED4);

//Shiftbrite myShiftbrite(p9, p10, p11, p12, p13);
RGBLed myRGBLed(p11,p12,p13);

//also setting any unused analog input pins to digital outputs reduces A/D noise a bit
//see http://mbed.org/users/chris/notebook/Getting-best-ADC-performance/
DigitalOut P16(p16);
DigitalOut P17(p17);
DigitalOut P18(p18);
DigitalOut P19(p19);
DigitalOut P20(p20);




// Global variables used in callbacks and main program
// C variables in interrupt routines should use volatile keyword
int volatile heat_setting=75; // heat to temp
int volatile cool_setting=70; // cool to temp
int volatile mode_change = 0; // mode change variable
int volatile temp_change = 0;
int volatile beep1 = 0;
int volatile beep2 = 0;
bool volatile mode=false; // heat or cool mode

void display(float tempC, float tempF, int setHC, int setHF, int setCC, int setCF,  Statetype state)
{
    int C,F;
    F = static_cast<int>(tempF);
    C = static_cast<int>(tempC);
    if(temp_change == 0){
        switch(state){
            case OFF:
                uLCD.color(BLACK);
                uLCD.text_width(2);
                uLCD.text_height(2);
                uLCD.locate(3,3);
                uLCD.printf("%d F",F);
                break;
            case Heat_off:
            case Heat_on:
                uLCD.color(WHITE);
                uLCD.text_width(1);
                uLCD.text_height(1);
                uLCD.locate(8,4);
                uLCD.printf("%d F",setHF);
                uLCD.text_width(2);
                uLCD.text_height(2);
                uLCD.locate(3,4);
                uLCD.printf("%d F",F);
                break;
            case Cool_off:
            case Cool_on:
                uLCD.color(WHITE);
                uLCD.text_width(1);
                uLCD.text_height(1);
                uLCD.locate(8,11);
                uLCD.printf("%d F",setCF);
                uLCD.text_width(2);
                uLCD.text_height(2);
                uLCD.locate(3,3);
                uLCD.printf("%d F",F);
                break;
            
        }
    }
    else{
        switch(state){
            case OFF:
                uLCD.text_width(2);
                uLCD.text_height(2);
                uLCD.locate(3,3);
                uLCD.printf("%d C",C);
                break;
            case Heat_off:
            case Heat_on:
                uLCD.text_width(1);
                uLCD.text_height(1);
                uLCD.locate(8,4);
                uLCD.printf("%d C",setHC);
                uLCD.text_width(2);
                uLCD.text_height(2);
                uLCD.locate(3,4);
                uLCD.printf("%d C",C);
                break;
            case Cool_off:
            case Cool_on:
                uLCD.text_width(1);
                uLCD.text_height(1);
                uLCD.locate(8,11);
                uLCD.printf("%d C",setCC);
                uLCD.text_width(2);
                uLCD.text_height(2);
                uLCD.locate(3,3);
                uLCD.printf("%d C",C);
                break;
            
        }       
    }
    
}
// Callback routine is interrupt activated by a debounced pb1 hit
void pb1_hit_callback (void)
{
// ADD CODE HERE
    beep1++;
    if(temp_change == 0){
        if(mode_change == 1)
            heat_setting++;
        else if(mode_change ==2)
            cool_setting++;
    }
    else{
        if(mode_change == 1)
            heat_setting=heat_setting+1.8;
        else if(mode_change ==2)
            cool_setting=cool_setting+1.8;
                
    }
}
// Callback routine is interrupt activated by a debounced pb2 hit
void pb2_hit_callback (void)
{
// ADD CODE HERE
    beep1++;
    
    if(temp_change == 0){
        if(mode_change == 1)
            heat_setting--;
        else if(mode_change ==2)
            cool_setting--;
    }
    else{
        if(mode_change == 1)
            heat_setting=heat_setting-1.8;
        else if(mode_change ==2)
            cool_setting=cool_setting-1.8;
                
    }
    
}
// Callback routine is interrupt activated by a debounced pb3 hit
void pb3_hit_callback (void)
{
    mode_change = ( mode_change + 1 ) % 3;
}

void pb4_hit_callback (void)
{
    temp_change = (temp_change+1)%2;
}

int main()
{
    float tempC=0.0, tempF=0.0;
 //   myRGBLed.write(1.0,0,0);
    // Use internal pullups for the three pushbuttons
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    pb4.mode(PullUp);
    
    // Delay for initial pullup to take effect
    wait(.01);
    // Setup Interrupt callback functions for a pb hit
    pb1.attach_deasserted(&pb1_hit_callback);
    pb2.attach_deasserted(&pb2_hit_callback);
    pb3.attach_deasserted(&pb3_hit_callback);
    pb4.attach_deasserted(&pb4_hit_callback);
    // Start sampling pb inputs using interrupts
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
    pb3.setSampleFrequency();
    pb4.setSampleFrequency();
    // pushbuttons now setup and running


    // start I/O examples - DELETE THIS IN YOUR CODE..BUT WILL USE THESE I/O IDEAS ELSEWHERE
    // since all this compiles - the needed *.h files for these are in the project
    //
    //Current_temp = myTMP36; //Read temp sensor
    printf("Hello PC World\n\r"); // need terminal application running on PC to see this output
   // uLCD.printf("\n\rHello LCD World\n\r"); // LCD
    mySpeaker.PlayNote(500.0, 1.0, 1.0); // Speaker buzz
    //myShiftbrite.write( 0, 50 ,0); // Green RGB LED
    // SD card write file example - prints error message on PC when running until SD card hooked up
    // Delete to avoid run time error
    /*
    mkdir("/sd/mydir", 0777); // set up directory and permissions
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w"); //open SD
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    fprintf(fp, "Hello SD Card World!"); // write SD
    fclose(fp); // close SD card
    */
    //
    // end I/O examples




    // State machine code below will need changes and additions
    while (1) {
        {
            Statetype state = Off;
            int setHC,setCC;
            int prev_heat_setting, prev_cool_setting, prev_mode_change,prev_C,prev_F,prev_temp_change;
            
            int C,F;
    
           prev_mode_change = -1;
            while(1) {              
            
            tempC = myTMP36.read();
            tempF = (9.0*tempC)/5.0 + 32.0;         
            setHC = static_cast<int>( (static_cast<float>(heat_setting)-32)/1.8 );    
            setCC = static_cast<int>( (static_cast<float>(cool_setting)-32)/1.8 );    
            F = static_cast<int>(tempF);
            C = static_cast<int>(tempC);           
           
           
           if(beep1 >0){
                mySpeaker.PlayNote(1000.0, 0.02, 1.0);
                beep1 = 0;
            }
            if(beep2 >0){
                mySpeaker.PlayNote(1500.0, 0.05, 1.0);
                beep2 = 0;
            }
            if(prev_heat_setting != heat_setting){
                display(tempC,tempF, setHC, heat_setting, setCC, cool_setting, state);
                prev_heat_setting = heat_setting;
            }
            if(temp_change != prev_temp_change){
                display(tempC,tempF, setHC, heat_setting, setCC, cool_setting, state);
                prev_temp_change = temp_change;             
            }
            if(prev_cool_setting != cool_setting){
                display(tempC,tempF, setHC, heat_setting, setCC, cool_setting, state);
                prev_cool_setting = cool_setting;
            
            }
            if(prev_C != C)
            {
                if(temp_change ==1)
                    display(tempC,tempF, setHC, heat_setting, setCC, cool_setting, state);                  
                prev_C=C;
            }
            if(prev_F !=F)
            {
                if(temp_change ==0)
                    display(tempC,tempF, setHC, heat_setting, setCC, cool_setting, state);
                prev_F=F;
            }
            
            if(prev_mode_change != mode_change){
                beep2++;
                switch(mode_change){
                    case 0:
                        state = Off;
                        
                        uLCD.cls();

                        uLCD.circle(65, 60, 55, WHITE);
                        uLCD.filled_circle(65,60,45,GREEN); 
                        uLCD.textbackground_color(GREEN);                   
                        uLCD.color(BLACK);
                        uLCD.text_width(1);
                        uLCD.text_width(1);
                        uLCD.locate(8,10);
                        uLCD.printf("OFF");                    
                        break;
                    case 1:   
          
                        state = Heat_off;
                        uLCD.cls();

                        uLCD.circle(65, 60, 55, WHITE);
                        uLCD.filled_circle(65,60,45,BLACK);
                        uLCD.circle(65,60,45,WHITE);
                        uLCD.triangle(65,45,55,55,75,55,WHITE);          
                        uLCD.triangle(65,46,56,54,74,54,WHITE);          
                        uLCD.triangle(65,47,57,53,73,53,WHITE);   
                        uLCD.textbackground_color(BLACK);            
                        break;
                    case 2:
                        state = Cool_off;
                        uLCD.cls();

                        uLCD.circle(65, 60, 55, WHITE);
                        uLCD.filled_circle(65,60,45,BLACK);
                        uLCD.circle(65,60,45,WHITE);
                        uLCD.triangle(65,80,55,70,75,70,WHITE);          
                        uLCD.triangle(65,79,56,71,74,71,WHITE);          
                        uLCD.triangle(65,78,57,72,73,72,WHITE);     
                        uLCD.textbackground_color(BLACK);        
                        break;
                }
                
                prev_mode_change = mode_change;
                display(tempC,tempF, setHC, heat_setting, setCC, cool_setting, state);
            }
            
                switch (state) {
                    case Off:
                        myLED1 = 0;
                        myLED2 = 0;
                        myLED3 = 0;
                        myLED4 = 0;
                        myRGBLed.write(0,1,0);
                         
                        break;
                        
                    case Cool_off:
                        myRGBLed.write(0,0,0);
                        myLED1 = 0;
                        myLED2 = 1;
                        myLED3 = 0;
                        myLED4 = 0;
                        
                        
                        
                        if(tempF >= cool_setting + 1){
                            beep2++;
                            state = Cool_on;
                            uLCD.cls();
                            uLCD.circle(65, 60, 55, WHITE);
                            uLCD.filled_circle(65,60,45,BLUE);
                            uLCD.textbackground_color(BLUE);
                            uLCD.triangle(65,80,55,70,75,70,WHITE);          
                            uLCD.triangle(65,79,56,71,74,71,WHITE);          
                            uLCD.triangle(65,78,57,72,73,72,WHITE);  
                            uLCD.textbackground_color(BLUE);     
                            uLCD.color(WHITE);


                            display(tempC,tempF, setHC, heat_setting, setCC, cool_setting, state);
                        }
                        break;
                        
                    case Cool_on:
                        myRGBLed.write(0,0,1);
                        myLED1 = 0;
                        myLED2 = 1;
                        myLED3 = 0;
                        myLED4 = 1;
                        if(tempF <= cool_setting- 1){
                            beep2++;
                            state = Cool_off;
                            uLCD.cls();
                            uLCD.circle(65, 60, 55, WHITE);
                        uLCD.filled_circle(65,60,45,BLACK);
                        uLCD.circle(65,60,45,WHITE);
                        uLCD.triangle(65,80,55,70,75,70,WHITE);          
                        uLCD.triangle(65,79,56,71,74,71,WHITE);          
                        uLCD.triangle(65,78,57,72,73,72,WHITE);     
                        uLCD.textbackground_color(BLACK);     
                            uLCD.color(WHITE);
                            display(tempC,tempF, setHC, heat_setting, setCC, cool_setting, state);
                        }
                        break;
                        
                        
                    case Heat_off:
                        myRGBLed.write(0,0,0);
                        myLED1 = 1;
                        myLED2 = 0;
                        myLED3 = 0;
                        myLED4 = 0;
                        if(tempF <= heat_setting - 1){
                            beep2++;
                            state = Heat_on;
                            uLCD.cls();
                        
                        uLCD.circle(65, 60, 55, WHITE);
                        uLCD.filled_circle(65,60,45,RED);

                        uLCD.triangle(65,45,55,55,75,55,WHITE);          
                        uLCD.triangle(65,46,56,54,74,54,WHITE);          
                        uLCD.triangle(65,47,57,53,73,53,WHITE);   
                        uLCD.textbackground_color(RED); 
                        uLCD.color(WHITE);
                        display(tempC,tempF, setHC, heat_setting, setCC, cool_setting, state);
                                
                        }
                        break;
                        
                    case Heat_on:
                       myRGBLed.write(1,0,0);
                        myLED1 = 1;
                        myLED2 = 0;
                        myLED3 = 0;
                        myLED4 = 1;
                        if(tempF >= heat_setting+ 1){
                            beep2++;
                            state = Heat_off;
                            uLCD.cls();
                        uLCD.circle(65, 60, 55, WHITE);
                        uLCD.filled_circle(65,60,45,BLACK);
                        uLCD.circle(65,60,45,WHITE);
                        uLCD.triangle(65,45,55,55,75,55,WHITE);          
                        uLCD.triangle(65,46,56,54,74,54,WHITE);          
                        uLCD.triangle(65,47,57,53,73,53,WHITE);   
                        uLCD.textbackground_color(BLACK);      
                            display(tempC,tempF, setHC, heat_setting, setCC, cool_setting, state);
                        }
                        break;
                } 

                wait(0.4);
            }
            
            
            
        }
    }
}