// Include header files for platform
#include "mbed.h"
#include "wave_player.h"
#include "SDFileSystem.h"
#include "Shiftbrite.h"
#include <vector>
#include "MMA8452.h" 

// Include header files for roboFrogger project
#include "globals.h"
#include "map_public.h"
#include "robot.h"
#include "cars.h"
//#include "wave_player.h"

void youwin();


//Platform initialization
DigitalIn right_pb(p24);  // push bottom
DigitalIn left_pb(p21); // push bottom
DigitalIn up_pb(p22);    // push bottom
DigitalIn down_pb(p23);  // push bottom
uLCD_4DGL uLCD(p9,p10,p11); // LCD (serial tx, serial rx, reset pin;)
Serial pc(USBTX,USBRX);     // used by Accelerometer
MMA8452 acc(p28, p27, 100000); // Accelerometer
DigitalOut myled(LED1);
SDFileSystem sd(p5,p6,p7,p8,"sd");


int main()
{
    // Initialize the timer
    /// [Example of time control implementation]
    /// Here is a rough example to implement the timer control <br><br>
    int tick, pre_tick;
    srand (time(NULL));
    Timer timer;
    timer.start();
    tick = timer.read_ms();
    pre_tick = tick;
    
    double score=0;
        
    // Initialize the buttons
    left_pb.mode(PullUp);  // The variable left_pb will be zero when the pushbutton for moving the player left is pressed
    right_pb.mode(PullUp); // The variable rightt_pb will be zero when the pushbutton for moving the player right is pressed
    up_pb.mode(PullUp);    //the variable fire_pb will be zero when the pushbutton for firing a missile is pressed
    down_pb.mode(PullUp);  //the variable fire_pb will be zero when the pushbutton for firing a missile is pressed
    
    

    /// [Example of the game control implementation]
    /// Here is the example to initialize the game <br><br>
    uLCD.cls();
    //map_init();
    //robot_init(0,8);
    
    double x_, y_, z_;
    double x=0;
    double y=8;
    
    int life = 3;
  
 
    int level=0;
    
    
    //Start Screen
    uLCD.locate(0,0);
    uLCD.printf("RoboFrog");
    uLCD.locate(0,2);
    uLCD.printf("Press UP");
    uLCD.locate(0,3);
    uLCD.printf("->Level 1");
    uLCD.locate(0,5);
    uLCD.printf("Press LEFT");
    uLCD.locate(0,6);
    uLCD.printf("->Level 2");
    uLCD.locate(0,8);
    uLCD.printf("Press RIGHT");
    uLCD.locate(0,9);
    uLCD.printf("->Level 3");
    
   
    while(1)
    {
        if(!up_pb)
        {
          level=1;
          break;
        }
        if(!left_pb)
        {
          level=2;
          break;
        }
        if(!right_pb)
        {
          level=3;
          break;
        }
    }
    uLCD.cls();
    if(level==1)
    {
    /// 1. Begin the game loop
      
      uLCD.printf("Level 1 Start!");
      wait(0.5);
      uLCD.cls();
      map_init();
      robot_draw(16,0);
      robot_draw(15,0);
      robot_draw(14,0);
      robot_init(0,8);
      //level 1 car objects
      //redCar
      car_t redCar;
      redCar.lane=1;
      redCar.car_color=0xFF0000;
      car_init(&redCar);
      //blueCar
      car_t blueCar;
      blueCar.lane=2;
      blueCar.car_color=0x0000FF;
      car_init(&blueCar);
      //whiteCar
      car_t whiteCar;
      whiteCar.lane=3;
      whiteCar.car_color=0xFFFFFF;
      car_init(&whiteCar);
      
      
      while(1) 
      {
        tick = timer.read_ms(); // Read current time
        /// 2. Implement the code to get user input and update the roboFrogger
        /// -[Hint] Implement the code to move RoboFrogger. You could use either push-button or accelerometer. <br>
        acc.readXYZGravity(&x_,&y_,&z_); //read accelerometer
        //car objects movemetn
        car_move(&redCar,redCar.car_blk_x,redCar.car_blk_y);
        redCar.car_motion = CAR_UP;
        drive(&redCar);
        
        car_move(&blueCar,blueCar.car_blk_x,blueCar.car_blk_y);
        blueCar.car_motion = CAR_UP;
        drive(&blueCar);
        
        car_move(&whiteCar,whiteCar.car_blk_x,whiteCar.car_blk_y);
        whiteCar.car_motion = CAR_UP;
        drive(&whiteCar);
        
        //push button input and robot movement
        if(!left_pb)
        {
            x=x-1;
            robot_draw(x,y);
            robot_clear(x+1,y);
            map_draw_grid(x+1,y);
        
        }
        if(!right_pb)
        {
            x=x+1;
            robot_draw(x,y);
            robot_clear(x-1,y);
            map_draw_grid(x-1,y);            
        }
        if(!up_pb)
        {
            y=y-1;
            if(y>15)
            {
              y = 0;
              robot_clear(x,15);
              map_draw_grid(x,15);
            }
              
            if(y<0)
            {
              y= 15;
              robot_clear(x,0);
              map_draw_grid(x,0);
            }
            robot_draw(x,y);
            robot_clear(x,y+1);
            map_draw_grid(x,y+1);
        }
        if(!down_pb)
        {
            y=y+1;
            if(y>15)
            {
              y = 0;
              robot_clear(x,15);
              map_draw_grid(x,15);
            }
              
            if(y<0)
            {
              y=15;
              robot_clear(x,0);
              map_draw_grid(x,0);
            }
   
           
            robot_draw(x,y);
            robot_clear(x,y-1);
            map_draw_grid(x,y-1);
        }
       
        
         if((x==redCar.car_blk_x && y==redCar.car_blk_y) || 
         (x==blueCar.car_blk_x && y == blueCar.car_blk_y) ||
         (x==whiteCar.car_blk_x && y == whiteCar.car_blk_y))
         {
            life--;
            robot_clear(x,y);
            map_draw_grid(x,y);
            x=0;
            y=8;
            robot_init(0,8);
         }
        
        if(life==0)
         collision();
        
        score = map_eat_candy(x,y)+score;//saving scores
        uLCD.locate(0,1);
        uLCD.printf("Score:%4.1f ",score); //You could remove this code if you already make the accelerometer work.
        uLCD.locate(10,1);
        uLCD.printf(" Life: ");
       
        if((tick-pre_tick)>500) // Time step control
            pre_tick = tick; // update the previous tick
        if(x==16||(!left_pb&&!right_pb&&!up_pb&&!down_pb))//heat the safetyzone, go to next level
        {
        //
           //lv2
           x=0;
           y=8;
           uLCD.cls();                  
           uLCD.printf("Level 2 Start!");
           wait(0.5);
           uLCD.cls();
           map_init();
           robot_init(0,8);
           //level 1 car objects
            //redCar
           car_t redCar;
           redCar.lane=1;
           redCar.car_color=0xFF0000;
           car_init(&redCar);
           //blueCar
           car_t blueCar;
           blueCar.lane=2;
           blueCar.car_color=0x0000FF;
           car_init(&blueCar);
           //whiteCar
           car_t whiteCar;
           whiteCar.lane=3;
           whiteCar.car_color=0xFFFFFF;
           car_init(&whiteCar);
           //yellowCar
           car_t yellowCar;
           yellowCar.lane=4;
           yellowCar.car_color=0xFFFF00;
           car_init(&yellowCar);
                  
                  
           while(1) {
             tick = timer.read_ms(); // Read current time
           /// 2. Implement the code to get user input and update the roboFrogger
           /// -[Hint] Implement the code to move RoboFrogger. You could use either push-button or accelerometer. <br>
            acc.readXYZGravity(&x_,&y_,&z_); //read accelerometer
           //car objects movemetn
            car_move(&redCar,redCar.car_blk_x,redCar.car_blk_y);
            redCar.car_motion = CAR_UP;
            drive(&redCar);
           
            car_move(&blueCar,blueCar.car_blk_x,blueCar.car_blk_y);
            blueCar.car_motion = CAR_UP;
            drive(&blueCar);
                  
            car_move(&whiteCar,whiteCar.car_blk_x,whiteCar.car_blk_y);
            whiteCar.car_motion = CAR_UP;
            drive(&whiteCar);
                    
            car_move(&yellowCar,yellowCar.car_blk_x,yellowCar.car_blk_y);
            yellowCar.car_motion = CAR_UP;
            drive(&yellowCar);
                                       
            //push button input and robot movement
            if(!left_pb)
            {
               x=x-1;
               robot_draw(x,y);
               robot_clear(x+1,y);
               map_draw_grid(x+1,y);
             }
             if(!right_pb)
             {
                x=x+1;
                robot_draw(x,y);
                robot_clear(x-1,y);
                map_draw_grid(x-1,y);            
             }
             if(!up_pb)
             {
                y=y-1;
                if(y>15)
                {
                   y = 0;
                   robot_clear(x,15);
                   map_draw_grid(x,15);
                }
                if(y<0)
                {
                   y= 15;
                   robot_clear(x,0);
                   map_draw_grid(x,0);
                }
                   robot_draw(x,y);
                   robot_clear(x,y+1);
                   map_draw_grid(x,y+1);
                }
                if(!down_pb)
                {
                    y=y+1;
                    if(y>15)
                    {
                      y = 0;
                      robot_clear(x,15);
                      map_draw_grid(x,15);
                    }
                         
                    if(y<0)
                    {
                      y= 15;
                      robot_clear(x,0);
                      map_draw_grid(x,0);
                    }
        
                    robot_draw(x,y);
                    robot_clear(x,y-1);
                    map_draw_grid(x,y-1);
                }
                   
                    
                   if((x==redCar.car_blk_x && y==redCar.car_blk_y) || 
                   (x==blueCar.car_blk_x && y == blueCar.car_blk_y) ||
                   (x==whiteCar.car_blk_x && y == whiteCar.car_blk_y) ||
                   (x==yellowCar.car_blk_x && y == yellowCar.car_blk_y))
                   {
                        life--;
                        robot_clear(x,y);
                        map_draw_grid(x,y);
                        x=0;
                        y=8;
                        robot_init(0,8);
                   }
                    
                    if(life==0)
                     collision();
                    
                    score = map_eat_candy(x,y)+score;
                    uLCD.locate(0,1);
                    uLCD.printf("Score:%4.1f ",score); //You could remove this code if you already make the accelerometer work.
                    uLCD.locate(10,1);
                    uLCD.printf(" Life:%d",life);
                    if((tick-pre_tick)>500) // Time step control
                        pre_tick = tick; // update the previous tick
                    if(x==16||(!left_pb&&!right_pb&&!up_pb&&!down_pb))//heat the safetyzone, go to next level
                    {
                    ////// 
                      //lv3
                       x=0;
                       y=8;
                       uLCD.cls();                  
                       uLCD.printf("Level 3 Start!");
                       wait(0.5);
                       uLCD.cls();
                       map_init();
                       robot_init(0,8);
                       //level 1 car objects
                        //redCar
                       car_t redCar;
                       redCar.lane=1;
                       redCar.car_color=0xFF0000;
                       car_init(&redCar);
                       //blueCar
                       car_t blueCar;
                       blueCar.lane=2;
                       blueCar.car_color=0x0000FF;
                       car_init(&blueCar);
                       //whiteCar
                       car_t whiteCar;
                       whiteCar.lane=3;
                       whiteCar.car_color=0xFFFFFF;
                       car_init(&whiteCar);
                       //yellowCar
                       car_t yellowCar;
                       yellowCar.lane=4;
                       yellowCar.car_color=0xFFFF00;
                       car_init(&yellowCar);
                       //orangeCar
                       car_t orangeCar;
                       orangeCar.lane=5;
                       orangeCar.car_color=0xFFA500;
                       car_init(&orangeCar);
                              
                              
                       while(1) {
                         tick = timer.read_ms(); // Read current time
                       /// 2. Implement the code to get user input and update the roboFrogger
                       /// -[Hint] Implement the code to move RoboFrogger. You could use either push-button or accelerometer. <br>
                        acc.readXYZGravity(&x_,&y_,&z_); //read accelerometer
                       //car objects movemetn
                        car_move(&redCar,redCar.car_blk_x,redCar.car_blk_y);
                        redCar.car_motion = CAR_UP;
                        drive(&redCar);
                       
                        car_move(&blueCar,blueCar.car_blk_x,blueCar.car_blk_y);
                        blueCar.car_motion = CAR_UP;
                        drive(&blueCar);
                              
                        car_move(&whiteCar,whiteCar.car_blk_x,whiteCar.car_blk_y);
                        whiteCar.car_motion = CAR_UP;
                        drive(&whiteCar);
                                
                        car_move(&yellowCar,yellowCar.car_blk_x,yellowCar.car_blk_y);
                        yellowCar.car_motion = CAR_UP;
                        drive(&yellowCar);
                        
                        car_move(&orangeCar,orangeCar.car_blk_x,yellowCar.car_blk_y);
                        orangeCar.car_motion = CAR_UP;
                        drive(&orangeCar);
                                                   
                        //push button input and robot movement
                        if(!left_pb)
                        {
                           x=x-1;
                           robot_draw(x,y);
                           robot_clear(x+1,y);
                           map_draw_grid(x+1,y);
                         }
                         if(!right_pb)
                         {
                            x=x+1;
                            robot_draw(x,y);
                            robot_clear(x-1,y);
                            map_draw_grid(x-1,y);            
                         }
                         if(!up_pb)
                         {
                            y=y-1;
                            if(y>15)
                            {
                               y = 0;
                               robot_clear(x,15);
                               map_draw_grid(x,15);
                            }
                            if(y<0)
                            {
                               y= 15;
                               robot_clear(x,0);
                               map_draw_grid(x,0);
                            }
                               robot_draw(x,y);
                               robot_clear(x,y+1);
                               map_draw_grid(x,y+1);
                            }
                            if(!down_pb)
                            {
                                y=y+1;
                                if(y>15)
                                {
                                  y = 0;
                                  robot_clear(x,15);
                                  map_draw_grid(x,15);
                                }
                                     
                                if(y<0)
                                {
                                  y= 15;
                                  robot_clear(x,0);
                                  map_draw_grid(x,0);
                                }
                    
                                robot_draw(x,y);
                                robot_clear(x,y-1);
                                map_draw_grid(x,y-1);
                            }
                               
                                
                               if((x==redCar.car_blk_x && y==redCar.car_blk_y) || 
                               (x==blueCar.car_blk_x && y == blueCar.car_blk_y) ||
                               (x==whiteCar.car_blk_x && y == whiteCar.car_blk_y) ||
                               (x==yellowCar.car_blk_x && y == yellowCar.car_blk_y) ||
                               (x==orangeCar.car_blk_x && y == orangeCar.car_blk_y))
                               {
                                    life--;
                                    robot_clear(x,y);
                                    map_draw_grid(x,y);
                                    x=0;
                                    y=8;
                                    robot_init(0,8);
                               }
                                
                                if(life==0)
                                 collision();
                                
                                score = map_eat_candy(x,y)+score;
                                uLCD.locate(0,1);
                                uLCD.printf("Score:%4.1f ",score); //You could remove this code if you already make the accelerometer work.
                                uLCD.locate(10,1);
                                uLCD.printf(" Life:%d",life);
                                if((tick-pre_tick)>500) // Time step control
                                    pre_tick = tick; // update the previous tick
                                if(x==16||(!left_pb&&!right_pb&&!up_pb&&!down_pb))//heat the safetyzone, go to next level
                                {
                                     uLCD.cls();
                                     uLCD.locate(6,8);
                                     uLCD.printf("You Win");
                                     uLCD.locate(3,10);
                                     uLCD.printf("Score is:%4.1f",score);
                                     while(1)
                                     {}
                                }
                        }
                                   
                    /////    
                    }
          }   
          
        //    
        }
  }//end while
 }//end level==1
   if(level==2)
   {
    ////
    //lv2
           uLCD.cls();                  
           uLCD.printf("Level 2 Start!");
           wait(0.5);
           uLCD.cls();
           map_init();
           robot_init(0,8);
           //level 1 car objects
            //redCar
           car_t redCar;
           redCar.lane=1;
           redCar.car_color=0xFF0000;
           car_init(&redCar);
           //blueCar
           car_t blueCar;
           blueCar.lane=2;
           blueCar.car_color=0x0000FF;
           car_init(&blueCar);
           //whiteCar
           car_t whiteCar;
           whiteCar.lane=3;
           whiteCar.car_color=0xFFFFFF;
           car_init(&whiteCar);
           //yellowCar
           car_t yellowCar;
           yellowCar.lane=4;
           yellowCar.car_color=0xFFFF00;
           car_init(&yellowCar);
                  
                  
           while(1) {
             tick = timer.read_ms(); // Read current time
           /// 2. Implement the code to get user input and update the roboFrogger
           /// -[Hint] Implement the code to move RoboFrogger. You could use either push-button or accelerometer. <br>
            acc.readXYZGravity(&x_,&y_,&z_); //read accelerometer
           //car objects movemetn
            car_move(&redCar,redCar.car_blk_x,redCar.car_blk_y);
            redCar.car_motion = CAR_UP;
            drive(&redCar);
           
            car_move(&blueCar,blueCar.car_blk_x,blueCar.car_blk_y);
            blueCar.car_motion = CAR_UP;
            drive(&blueCar);
                  
            car_move(&whiteCar,whiteCar.car_blk_x,whiteCar.car_blk_y);
            whiteCar.car_motion = CAR_UP;
            drive(&whiteCar);
                    
            car_move(&yellowCar,yellowCar.car_blk_x,yellowCar.car_blk_y);
            yellowCar.car_motion = CAR_UP;
            drive(&yellowCar);
                                       
            //push button input and robot movement
            if(!left_pb)
            {
               x=x-1;
               robot_draw(x,y);
               robot_clear(x+1,y);
               map_draw_grid(x+1,y);
             }
             if(!right_pb)
             {
                x=x+1;
                robot_draw(x,y);
                robot_clear(x-1,y);
                map_draw_grid(x-1,y);            
             }
             if(!up_pb)
             {
                y=y-1;
                if(y>15)
                {
                   y = 0;
                   robot_clear(x,15);
                   map_draw_grid(x,15);
                }
                if(y<0)
                {
                   y= 15;
                   robot_clear(x,0);
                   map_draw_grid(x,0);
                }
                   robot_draw(x,y);
                   robot_clear(x,y+1);
                   map_draw_grid(x,y+1);
                }
                if(!down_pb)
                {
                    y=y+1;
                    if(y>15)
                    {
                      y = 0;
                      robot_clear(x,15);
                      map_draw_grid(x,15);
                    }
                         
                    if(y<0)
                    {
                      y= 15;
                      robot_clear(x,0);
                      map_draw_grid(x,0);
                    }
        
                    robot_draw(x,y);
                    robot_clear(x,y-1);
                    map_draw_grid(x,y-1);
                }
                   
                    
                   if((x==redCar.car_blk_x && y==redCar.car_blk_y) || 
                   (x==blueCar.car_blk_x && y == blueCar.car_blk_y) ||
                   (x==whiteCar.car_blk_x && y == whiteCar.car_blk_y) ||
                   (x==yellowCar.car_blk_x && y == yellowCar.car_blk_y))
                   {
                        life--;
                        robot_clear(x,y);
                        map_draw_grid(x,y);
                        x=0;
                        y=8;
                        robot_init(0,8);
                   }
                    
                    if(life==0)
                     collision();
                    
                    score = map_eat_candy(x,y)+score;
                    uLCD.locate(0,1);
                    uLCD.printf("Score:%4.1f ",score); //You could remove this code if you already make the accelerometer work.
                    uLCD.locate(10,1);
                    uLCD.printf(" Life:%d",life);
                    if((tick-pre_tick)>500) // Time step control
                        pre_tick = tick; // update the previous tick
                    if(x==16||(!left_pb&&!right_pb&&!up_pb&&!down_pb))//heat the safetyzone, go to next level    
                    {
                      //lv3
                       x=0;
                       y=8;
                       uLCD.cls();                  
                       uLCD.printf("Level 3 Start!");
                       wait(0.5);
                       uLCD.cls();
                       map_init();
                       robot_init(0,8);
                       //level 1 car objects
                        //redCar
                       car_t redCar;
                       redCar.lane=1;
                       redCar.car_color=0xFF0000;
                       car_init(&redCar);
                       //blueCar
                       car_t blueCar;
                       blueCar.lane=2;
                       blueCar.car_color=0x0000FF;
                       car_init(&blueCar);
                       //whiteCar
                       car_t whiteCar;
                       whiteCar.lane=3;
                       whiteCar.car_color=0xFFFFFF;
                       car_init(&whiteCar);
                       //yellowCar
                       car_t yellowCar;
                       yellowCar.lane=4;
                       yellowCar.car_color=0xFFFF00;
                       car_init(&yellowCar);
                       //orangeCar
                       car_t orangeCar;
                       orangeCar.lane=5;
                       orangeCar.car_color=0xFFA500;
                       car_init(&orangeCar);
                              
                              
                       while(1) {
                         tick = timer.read_ms(); // Read current time
                       /// 2. Implement the code to get user input and update the roboFrogger
                       /// -[Hint] Implement the code to move RoboFrogger. You could use either push-button or accelerometer. <br>
                        acc.readXYZGravity(&x_,&y_,&z_); //read accelerometer
                       //car objects movemetn
                        car_move(&redCar,redCar.car_blk_x,redCar.car_blk_y);
                        redCar.car_motion = CAR_UP;
                        drive(&redCar);
                       
                        car_move(&blueCar,blueCar.car_blk_x,blueCar.car_blk_y);
                        blueCar.car_motion = CAR_UP;
                        drive(&blueCar);
                              
                        car_move(&whiteCar,whiteCar.car_blk_x,whiteCar.car_blk_y);
                        whiteCar.car_motion = CAR_UP;
                        drive(&whiteCar);
                                
                        car_move(&yellowCar,yellowCar.car_blk_x,yellowCar.car_blk_y);
                        yellowCar.car_motion = CAR_UP;
                        drive(&yellowCar);
                        
                        car_move(&orangeCar,orangeCar.car_blk_x,yellowCar.car_blk_y);
                        orangeCar.car_motion = CAR_UP;
                        drive(&orangeCar);
                                                   
                        //push button input and robot movement
                        if(!left_pb)
                        {
                           x=x-1;
                           robot_draw(x,y);
                           robot_clear(x+1,y);
                           map_draw_grid(x+1,y);
                         }
                         if(!right_pb)
                         {
                            x=x+1;
                            robot_draw(x,y);
                            robot_clear(x-1,y);
                            map_draw_grid(x-1,y);            
                         }
                         if(!up_pb)
                         {
                            y=y-1;
                            if(y>15)
                            {
                               y = 0;
                               robot_clear(x,15);
                               map_draw_grid(x,15);
                            }
                            if(y<0)
                            {
                               y= 15;
                               robot_clear(x,0);
                               map_draw_grid(x,0);
                            }
                               robot_draw(x,y);
                               robot_clear(x,y+1);
                               map_draw_grid(x,y+1);
                            }
                            if(!down_pb)
                            {
                                y=y+1;
                                if(y>15)
                                {
                                  y = 0;
                                  robot_clear(x,15);
                                  map_draw_grid(x,15);
                                }
                                     
                                if(y<0)
                                {
                                  y= 15;
                                  robot_clear(x,0);
                                  map_draw_grid(x,0);
                                }
                    
                                robot_draw(x,y);
                                robot_clear(x,y-1);
                                map_draw_grid(x,y-1);
                            }
                               
                                
                               if((x==redCar.car_blk_x && y==redCar.car_blk_y) || 
                               (x==blueCar.car_blk_x && y == blueCar.car_blk_y) ||
                               (x==whiteCar.car_blk_x && y == whiteCar.car_blk_y) ||
                               (x==yellowCar.car_blk_x && y == yellowCar.car_blk_y) ||
                               (x==orangeCar.car_blk_x && y == orangeCar.car_blk_y))
                               {
                                    life--;
                                    robot_clear(x,y);
                                    map_draw_grid(x,y);
                                    x=0;
                                    y=8;
                                    robot_init(0,8);
                               }
                                
                                if(life==0)
                                 collision();
                                
                                score = map_eat_candy(x,y)+score;
                                uLCD.locate(0,1);
                                uLCD.printf("Score:%4.1f ",score); //You could remove this code if you already make the accelerometer work.
                                uLCD.locate(10,1);
                                uLCD.printf(" Life:%d",life);
                                if((tick-pre_tick)>500) // Time step control
                                    pre_tick = tick; // update the previous tick
                                if(x==16||(!left_pb&&!right_pb&&!up_pb&&!down_pb))//heat the safetyzone, go to next level
                                {
                                     uLCD.cls();
                                     uLCD.locate(6,8);
                                     uLCD.printf("You Win");
                                     uLCD.locate(3,10);
                                     uLCD.printf("Score is:%4.1f",score);
                                     while(1)
                                     {}
                                }
                      }
                    }
    }
 ////    
 }
 
   if(level==3)
    {
    
                       uLCD.cls();                  
                       uLCD.printf("Level 3 Start!");
                       wait(0.5);
                       uLCD.cls();
                       map_init();
                       robot_init(0,8);
                       //level 1 car objects
                        //redCar
                       car_t redCar;
                       redCar.lane=1;
                       redCar.car_color=0xFF0000;
                       car_init(&redCar);
                       //blueCar
                       car_t blueCar;
                       blueCar.lane=2;
                       blueCar.car_color=0x0000FF;
                       car_init(&blueCar);
                       //whiteCar
                       car_t whiteCar;
                       whiteCar.lane=3;
                       whiteCar.car_color=0xFFFFFF;
                       car_init(&whiteCar);
                       //yellowCar
                       car_t yellowCar;
                       yellowCar.lane=4;
                       yellowCar.car_color=0xFFFF00;
                       car_init(&yellowCar);
                       //orangeCar
                       car_t orangeCar;
                       orangeCar.lane=5;
                       orangeCar.car_color=0xFFA500;
                       car_init(&orangeCar);
                              
                              
                       while(1) {
                         tick = timer.read_ms(); // Read current time
                       /// 2. Implement the code to get user input and update the roboFrogger
                       /// -[Hint] Implement the code to move RoboFrogger. You could use either push-button or accelerometer. <br>
                        acc.readXYZGravity(&x_,&y_,&z_); //read accelerometer
                       //car objects movemetn
                        car_move(&redCar,redCar.car_blk_x,redCar.car_blk_y);
                        redCar.car_motion = CAR_UP;
                        drive(&redCar);
                       
                        car_move(&blueCar,blueCar.car_blk_x,blueCar.car_blk_y);
                        blueCar.car_motion = CAR_UP;
                        drive(&blueCar);
                              
                        car_move(&whiteCar,whiteCar.car_blk_x,whiteCar.car_blk_y);
                        whiteCar.car_motion = CAR_UP;
                        drive(&whiteCar);
                                
                        car_move(&yellowCar,yellowCar.car_blk_x,yellowCar.car_blk_y);
                        yellowCar.car_motion = CAR_UP;
                        drive(&yellowCar);
                        
                        car_move(&orangeCar,orangeCar.car_blk_x,yellowCar.car_blk_y);
                        orangeCar.car_motion = CAR_UP;
                        drive(&orangeCar);
                                                   
                        //push button input and robot movement
                        if(!left_pb)
                        {
                           x=x-1;
                           robot_draw(x,y);
                           robot_clear(x+1,y);
                           map_draw_grid(x+1,y);
                         }
                         if(!right_pb)
                         {
                            x=x+1;
                            robot_draw(x,y);
                            robot_clear(x-1,y);
                            map_draw_grid(x-1,y);            
                         }
                         if(!up_pb)
                         {
                            y=y-1;
                            if(y>15)
                            {
                               y = 0;
                               robot_clear(x,15);
                               map_draw_grid(x,15);
                            }
                            if(y<0)
                            {
                               y= 15;
                               robot_clear(x,0);
                               map_draw_grid(x,0);
                            }
                               robot_draw(x,y);
                               robot_clear(x,y+1);
                               map_draw_grid(x,y+1);
                            }
                            if(!down_pb)
                            {
                                y=y+1;
                                if(y>15)
                                {
                                  y = 0;
                                  robot_clear(x,15);
                                  map_draw_grid(x,15);
                                }
                                     
                                if(y<0)
                                {
                                  y= 15;
                                  robot_clear(x,0);
                                  map_draw_grid(x,0);
                                }
                    
                                robot_draw(x,y);
                                robot_clear(x,y-1);
                                map_draw_grid(x,y-1);
                            }
                               
                                
                               if((x==redCar.car_blk_x && y==redCar.car_blk_y) || 
                               (x==blueCar.car_blk_x && y == blueCar.car_blk_y) ||
                               (x==whiteCar.car_blk_x && y == whiteCar.car_blk_y) ||
                               (x==yellowCar.car_blk_x && y == yellowCar.car_blk_y) ||
                               (x==orangeCar.car_blk_x && y == orangeCar.car_blk_y))
                               {
                                    life--;
                                    robot_clear(x,y);
                                    map_draw_grid(x,y);
                                    x=0;
                                    y=8;
                                    robot_init(0,8);
                               }
                                
                                if(life==0)
                                 collision();
                                
                                score = map_eat_candy(x,y)+score;
                                uLCD.locate(0,1);
                                uLCD.printf("Score:%4.1f ",score); //You could remove this code if you already make the accelerometer work.
                                uLCD.locate(10,1);
                                uLCD.printf(" Life:%d",life);
                                if((tick-pre_tick)>500) // Time step control
                                    pre_tick = tick; // update the previous tick
                                if(x==16||(!left_pb&&!right_pb&&!up_pb&&!down_pb))//heat the safetyzone, go to next level
                                {
                                     uLCD.cls();
                                     uLCD.locate(6,8);
                                     uLCD.printf("You Win");
                                     uLCD.locate(3,10);
                                     uLCD.printf("Score is:%4.1f",score);
                                     while(1)
                                     {}
                                }
   
       }
   }
   
}//end main         


