#ifndef INCLUDED_SBUS_H
#define INCLUDED_SBUS_H

#include "mbed.h"

class SBUS {
    public:
        // @parm    tx  communication tx pin
        //          rx  communocation rx pin
        SBUS(PinName tx, PinName rx);
        
        // channel array elements tag
        enum channelTag { right_RL, left_UD, right_UD, left_RL, sw1, sw2, sw3, sw4, sw5, sw6 };
        
        // stick value array elements tag
        enum stickName {
            analog_rx,
            analog_ry,
            analog_lx,
            analog_ly
        };
        
        // switch position tag
        enum switchPosition {
            Low,
            Neutral,
            High
        };
        
        // switchF position tag
        enum switchFPosition {
            FHigh,
            FLow
        };
        
        // function of getting stick value
        // @parm    tag stickName
        float getStickValue(int tag);
        
        // function of getting switch value
        // @parm    tag 0-12
        int getSwitchValue(int tag);
        
        // function of getting channel value
        // @parm    tag 0-25
        int getChannelValue(int tag);
        
        // function of getting connecting status
        bool getConnectStatus();
    
    private:
        Serial com;
        
        int stickMaximumValue;
        int stickNeutralValue;
        int stickMinimumValue;
        int stickResolution;
        bool connstatus;
        
        int channel[16];
        int receivedData[50];
        float stickValue[4];
        int switchFPositionValue[2];
        int switchPositionValue[3];
        int switchValue[12];
        
        void receiveData();
        
        void decordReceivedData();
        
        void convertReceivedData();
        
        void resetall();
};

#endif
