#ifndef INCLUDED_IM920
#define INCLUDED_IM920

#include "mbed.h"
#include "string.h"

class IM920 {
    public:
        IM920(PinName tx, PinName rx);
        
        enum deviceDataTag {
            Node,
            ID,
            RSSI
        };
        
        void baud(int baudrate);
        
        void attach(void (*func)());
        
        void write(int *pdata);
        
        int getDeviceInfo(int tag);
        
        int readByte(int byte);
        
        void readLine(int *buf, int byte = 64);
    
    private:
        Serial com;
        
        /*typedef void (*callback)();
        callback rxIrqFunc;*/
        void (*rxIrqFunc)();
        
        char receivedString[202];
        int deviceData[3];
        int receivedData[64];
        
        void receiveData();
        
        void resetString();
        
        void divideString();
    
};

#endif
