#include "IM920.h"
#include "mbed.h"
#include "string.h"

IM920::IM920(PinName tx, PinName rx) : com(tx, rx)/*, rxIrqFunc(NULL)*/ {
    com.baud(19200);
    com.attach(this, &IM920::receiveData, Serial::RxIrq);
}

void IM920::baud(int baudrate) {
    com.baud(baudrate);
}

void IM920::attach(void (*func)()) {
    rxIrqFunc = func;
}

void IM920::write(int *pdata) {
    int dataNum = (sizeof pdata) / (sizeof pdata[0]);
    com.printf("TXDA ");
    for(int i = 0; i < dataNum; i++) com.printf("%02X", pdata[i]);
    com.printf("\r\n");
}

int IM920::getDeviceInfo(int tag) {
    return deviceData[tag];
}

int IM920::readByte(int byte) {
    return receivedData[byte];
}

void IM920::readLine(int *buf, int byte) {
    for(int i = 0; i < byte; i++) buf[i] = receivedData[i];
}

void IM920::receiveData() {
    char buf;
    static int count = 0;

    buf = com.getc();

    if(buf == '\n') {
        receivedString[count] = buf;
        count = 0;
        divideString();
    } else if(count == 0){
        resetString();
        receivedString[count] = buf;
        count++;
    } else {
        receivedString[count] = buf;
        count++;
    }
    (*rxIrqFunc)();
}

void IM920::resetString() {
    for(int i = 0; i < 202; i++) receivedString[i] = 0;
}

void IM920::divideString() {
    char *buf;
    char bufstr[67][5];
    int count = 0;

    buf = strtok(receivedString, ",:");
    strcpy(bufstr[count], buf);
    count++;
    while(buf != NULL) {
        buf = strtok(NULL, ",:");
        strcpy(bufstr[count], buf);
        count++;
    }

    for(int i = 0; i < 3; i++) deviceData[i] = strtol(bufstr[i], NULL, 16);
    for(int i = 0; i < 64; i++) receivedData[i] = strtol(bufstr[i + 3], NULL, 16);
}
