#include "mbed.h"
#include "C12832_lcd.h"

// LCD and Joystick Setting
C12832_LCD lcd;

BusIn Up(p15);
BusIn Down(p12);
BusIn Left(p13);
BusIn Right(p16);
BusOut Reset(p14);

// Custom Function 
void initialize();

// Main 
int main()
{
    initialize(); 
    while(1) 
    {
        lcd.locate(0,15);   // Set Location print a text    
        // Operations by Joystic
        if (Up)
            lcd.printf("UP");
        if (Down)
            lcd.printf("Down");        
        if (Left)
            lcd.printf("Left");           
        if (Right)
            lcd.printf("Right");           
        if (Reset)
            initialize();                                                     
    }
}
void initialize()
{
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Joystic and LCD Controller!");     
}