#include "mbed.h"
#include <string>
#include <map>
#include <queue>
#include <list>

#ifndef _ESP8266_WEB_SERVER_H
#define _ESP8266_WEB_SERVER_H

const char mimeHTML[] = "text/html";
const char mimeJavaScript[] = "text/javascript";
const char mimeCSS[] = "text/css";
const char mimeJPEG[] = "image/jpeg";
const char mimePNG[] = "image/png";
const char mimeGIF[] = "image/gif";
const char mimeICO[] = "image/x-icon";
const char mimeText[] = "text/plain";
const char mimeJSON[] = "application/json";

#define OPMODE_STATION  1
#define OPMODE_SOFTAP   2
#define OPMODE_ALL      3

extern const char* opModes[];

class ESP8266_WebRequest
{
    char* data;
    Serial *debugSerial;
    
    public:
        ESP8266_WebRequest(const char* packet, Serial* debug);
        ~ESP8266_WebRequest();
        int LinkID;
        void Read(void);
        std::string Method;
        std::string URI;
        std::map<std::string, std::string> Parameters;
};

class ESP8266_WebServer
{
    Serial *serial;
    char buffer[128];
    char reply[128];
    char response[2048];
    char reqBuffer[1024];
    volatile char* rxptr;
    volatile char* rxptrStored;
    volatile bool reqMode;
    volatile int ipdLen;
    volatile int reqLen;
    std::queue<ESP8266_WebRequest*, std::list<ESP8266_WebRequest*> > incoming;
    
    private:
        short data_waiting(void);
        short string_waiting(const char*);
        void readBuffer(void);
        void sendResponse(int linkID, int numBytes);
        void queueRequest(void);
        
    public:
        Serial *debugSerial;
        bool echoMode;
        
        ESP8266_WebServer(Serial *espUART);
        void rxint(void);
        void debugBuffers(Serial* target);
        void ResetModule(void);
        void Initialize(void);
        ESP8266_WebRequest* GetRequest(void);
        void SendError(int linkID, std::string error);
        void SendError(int linkID, const char* error);
        void Send404Error(int linkID);
        void SendReply(int linkID, std::string reply, const char* mimeType);
        void SendReply(int linkID, std::string reply, const char* mimeType, int maxAge);
        void SendReply(int linkID, char const* reply, int replySize, const char* mimeType);
        void SendReply(int linkID, char const* reply, int replySize, const char* mimeType, int maxAge);
        void SendReply(int linkID, char const* reply, const char* mimeType, int maxAge);
        void SendFile(int linkID, FileHandle* file, const char* mimeType);
        void SendFile(int linkID, FileHandle* file, const char* mimeType, int maxAge);
        int SendStream(int linkID, char const* reply, int StreamSize, int WindowSize, const char* mimeType, int maxAge);
        int SendStream(int linkID, char const* reply, int WindowSize);
        
        std::string GetStationMAC(void);
        std::string GetAPMAC(void);
        std::string GetStationIP(void);
        std::string GetAPIP(void);
        int GetOperatingMode(void);
        std::string GetStationSSID(void);
        std::list<std::string> ListAvailableSSID(void);
        std::string GetFirmwareVersion(void);
        
        bool SetOperatingMode(int mode);
        bool SetStationSSID(std::string newAP, std::string password);
};

#endif