/*
 * \file common_functions.c
 * \brief Add short description about this file!!!
 * Copyrigth Sensinode Ltd 2013
 *
 */
#include <stdint.h>
#include "common_functions.h"

uint8_t * common_write_32_bit(uint32_t value, uint8_t *ptr)
{
	*ptr++ = value >> 24;
	*ptr++ = value >> 16;
	*ptr++ = value >> 8;
	*ptr++ = value;
	return ptr;
}

uint32_t common_read_32_bit(const uint8_t *data_buf)
{
	uint32_t temp_32 = 0;
	temp_32 =  (uint32_t) (*data_buf++) << 24;
	temp_32 += (uint32_t) (*data_buf++) << 16;
	temp_32 += (uint32_t) (*data_buf++) << 8;
	temp_32 +=  *data_buf++;
	return temp_32;
}

uint8_t * common_write_32_bit_inverse(uint32_t value, uint8_t *ptr)
{
	ptr += 3;
	*ptr-- = value >> 24;
	*ptr-- = value >> 16;
	*ptr-- = value >> 8;
	*ptr = value;
	ptr += 4;
	return ptr;
}

uint32_t common_read_32_bit_inverse(const uint8_t *data_buf)
{
	uint32_t temp_32 = 0;
	data_buf += 3;
	temp_32 =  (uint32_t) (*data_buf--) << 24;
	temp_32 += (uint32_t) (*data_buf--) << 16;
	temp_32 += (uint32_t) (*data_buf--) << 8;
	temp_32 +=  *data_buf;
	return temp_32;
}


uint8_t * common_write_16_bit(uint16_t value, uint8_t *ptr)
{
	*ptr++ = value >> 8;
	*ptr++ = value;
	return ptr;
}

uint8_t * common_write_16_bit_inverse(uint16_t value, uint8_t *ptr)
{
	ptr++;
	*ptr-- = value >> 8;
	*ptr = value;
	ptr += 2;
	return ptr;
}

uint16_t common_read_16_bit(const uint8_t *data_buf)
{
	uint16_t temp_16 = 0;
	temp_16 += (uint16_t) (*data_buf++) << 8;
	temp_16 +=  *data_buf++;
	return temp_16;
}
