
/**
 * \file randLIB.h
 * \brief Pseudo Random Library API:
 *
 *
 * \section net-boot Network Bootstrap Control API:
 *  - randLIB_seed_random(), Set seed for pseudo random
 *  - randLIB_get_8bit(), Generate 8-bit random number
 *  - randLIB_get_16bit(),Generate 16-bit random number
 *  - randLIB_get_32bit(),Generate 32-bit random number
 *  - randLIB_get_n_bytes_random(), Generate n-bytes random numbers
 *
 */

#ifndef RANDLIB_H_
#define RANDLIB_H_
#ifdef __cplusplus
extern "C" {
#endif
/**
  * \brief Init seed for Pseudo Random.
  *
  * \return None
  *
  */
extern void randLIB_seed_random(void);

/**
  * \brief Generate 8-bit random number.
  *
  * \param None
  * \return 8-bit random number
  *
  */
extern uint8_t randLIB_get_8bit(void);

/**
  * \brief Generate 16-bit random number.
  *
  * \param None
  * \return 16-bit random number
  *
  */
extern uint16_t randLIB_get_16bit(void);

/**
  * \brief Generate 32-bit random number.
  *
  * \param None
  * \return 16-bit random number
  *
  */
extern uint32_t randLIB_get_32bit(void);

/**
  * \brief Generate n-bytes random numbers.
  *
  * \param data_ptr pointer where random will be stored
  * \param eight_bit_boundary how many bytes need random
  * \return 0 process valid
  * \return -1 Unsupported Parameters
  *
  */
extern int8_t randLIB_get_n_bytes_random(uint8_t *data_ptr, uint8_t eight_bit_boundary);

#ifdef __cplusplus
}
#endif
#endif /* RANDLIB_H_ */
