/*
 * arm_hal_timer.h
 *
 *  Created on: 14 Jan 2014
 *      Author: jarpas01
 */

#ifndef ARM_HAL_TIMER_H_
#define ARM_HAL_TIMER_H_
 #ifdef __cplusplus
extern "C" {
#endif
/**
 * \brief This function perform timer init.
 */
extern void arm_timer_init(void);
/**
 * \brief This function is API for set Timer interrupt handler for stack
 *
 * \param new_fp Function pointer for stack giving timer handler
 *
 */
extern void arm_timer_set_cb(void (*new_fp)(void));
/**
 * \brief This function is API for stack timer start
 *
 * \param slots define how many 50us slot time period will be started
 *
 */
extern void arm_timer_start(uint16_t slots);
/**
 * \brief This function is API for stack timer stop
 *
 */
extern void arm_timer_stop(void);
/**
 * \brief This function is API for stack timer to read active timer remaining slot count
 *
 * \return 50us time slot remaining
 */
extern uint16_t arm_timer_get_remaining_slots(void);
#ifdef __cplusplus
}
#endif

#endif /* ARM_HAL_TIMER_H_ */
