/*
 * Copyright ARM Ltd 2014
 */

#ifndef TASKLET_API_H_
#define TASKLET_API_H_
/**
 * \file tasklet_api.h
 * \brief Library Tasklet and Network event.
 *
 */
/**Network status events, these are posted with ID SYS_NETWORK*/
/** Connection to access point is ready. */
#define NET_READY			0
/** No Coordinator available. Note: Stack enter to IDLE automatically. net_stop() is not necessary  */
#define NET_NO_BEACON		1
/** No ND Router available. Note: Stack enter to IDLE automatically. net_stop() is not necessary */
#define NET_NO_ND_ROUTER	2
/** No PANA server available. Note: Only used ZIP Stack. Stack enter to IDLE automatically */
#define NET_NO_PANA_SERVER		3
/** PANA authentication has been failed. Note: Only used ZIP Stack. Stack enter to IDLE automatically */
#define NET_PANA_SERVER_AUTH_FAIL	4
/** Connection to AP lost and scanning has been started automatically. Application should wait response from scanning. NOTE Only used at BLE stack */
#define NET_BORDER_ROUTER_LOST	5
/** Host has loosing Connection to Parent. Application should start stack again just check if MLE UPDATE was happen. */
#define NET_PARENT_POLL_FAIL		6
/** ND DAD happen and user not want generate dynamically new. Note: Stack enter to IDLE automatically. net_stop() is not necessar*/
#define NET_DAD		7
 /*!
  * \enum s_tasklet
  * \brief Nanostack Library Tasklet.
  */
typedef enum s_tasklet
{
	SYSTEM,
	SYSTEM_TIMER,
	SYSTEM_MAC,
	TL_NETWORK,
	TL_MAIN,
	SYS_SOCKET,
	SYS_NETWORK,
	APP_SPESIFIC_EVENT,
	SYS_PIPE,
	PM_MAC,
	PM_ICMP,
	PM_UDP,
	PM_TCP,
	PM_MAX
}s_tasklet;

/*!
 * \enum s_event
 * \brief Nanostack Library Events.
 */
typedef enum s_event
{
	EV_INIT,
	EV_UART1,
	EV_UART0,
	EV_SPI,
	EV_SOCKET,
	EV_CORE_IDLE,
	EV_READY_TO_SLEEP,
	EV_TIMER,
	EV_NETWORK,
	EV_RF,
	EV_ECC,
	EV_MAX
}s_event;




#endif /* TASKLET_API_H_ */
