/*
 * \file common_functions.h
 * \brief Add short description about this file!!!
 * Copyrigth Sensinode Ltd 2013
 *
 */
#ifndef __COMMON_FUNCTIONS_H_
#define __COMMON_FUNCTIONS_H_
#ifdef __cplusplus
extern "C" {
#endif
/*
 * Common write 32-bit variable to 8-bit pointer.
 *
 * \param value 32-bit variable
 * \param ptr pointer where data to be writed
 *
 * \return updated pointer
 */
extern uint8_t * common_write_32_bit(uint32_t value, uint8_t *ptr);

/*
 * Common read 32-bit variable from 8-bit pointer.
 *
 * \param data_buf pointer where data to be readed
 *
 * \return 32-bit variable
 */
extern uint32_t common_read_32_bit(const uint8_t *data_buf);

extern uint8_t * common_write_32_bit_inverse(uint32_t value, uint8_t *ptr);
extern uint32_t common_read_32_bit_inverse(const uint8_t *data_buf);

extern uint8_t * common_write_16_bit_inverse(uint16_t value, uint8_t *ptr);

/*
 * Common write 16-bit variable to 8-bit pointer.
 *
 * \param value 16-bit variable
 * \param ptr pointer where data to be writed
 *
 * \return updated pointer
 */
extern uint8_t * common_write_16_bit(uint16_t value, uint8_t *ptr);

/*
 * Common read 16-bit variable from 8-bit pointer.
 *
 * \param data_buf pointer where data to be readed
 *
 * \return 16-bit variable
 */
extern uint16_t common_read_16_bit(const uint8_t *data_buf);
#ifdef __cplusplus
}
#endif
#endif /*__COMMON_FUNCTIONS_H_*/
