/*
 * socket_security.h
 *
 *  Created on: 23.1.2012
 *      Author: user
 */

#ifndef SOCKET_SECURITY_H_
#define SOCKET_SECURITY_H_
#ifdef __cplusplus
extern "C" {
#endif
/**
 * \file socket_security.h
 * \brief Library Socket Security API.
 *
 * Nanostack Support TLS 1.2 for TCP security and PANA/EAP/TLS1.2 over UDP.
 * Both of Sockets support next TLS1.2 Authentication ciphers:
 *  - SEC_SOCKET_CIPHERSUITE_PSK,  TLS-PSK Cipher Suite is TLS_PSK_WITH_AES_128_CCM_8 as defined in [RFC 6655].
 *  - SEC_SOCKET_CIPHERSUITE_ECC, TLS-ECC Cipher Suite is TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8
 *
 * Socket Security Chiper select API:
 *  - sec_socket_set_chipher_suite_list(), SET socket TLS chipher Suite support
 *
 * Certification Chain Load to TLS:
 *  - sec_certificate_list_update(), SET Certificate chain for specific Application
 *
 * @code
 	 certificate_chain_entry_t  certificate_chain_entry;
 	 //Chain Root				1
	//Chain Root-MCA 			2
	//Chain Root-MCA-MICA 		3
	//Chain Root-MCA-MiCA-DEV 	4
	//Generate CertiChain for length 4
	certificate_chain_entry.certificate_owner = SEC_CERTIFICATE_ZIP;
	certificate_chain_entry.chain_length = 4;
	// Set Root
	certificate_chain_entry.certi_chain[0] = root_certificate;
	certificate_chain_entry.certi_len[0] = sizeof(root_certificate);
	certificate_chain_entry.key_chain[0] = rootpk;

	// Set MICA
	certificate_chain_entry.certi_chain[1] = mca_certi;
	certificate_chain_entry.certi_len[1] = sizeof(mca_certi);
	certificate_chain_entry.key_chain[1] = mca_pv;
	// Set MCA
	certificate_chain_entry.certi_chain[2] = mica_certi;
	certificate_chain_entry.certi_len[2] = sizeof(mica_certi);
	certificate_chain_entry.key_chain[2] = mica_pv;
	// SET DEV
	certificate_chain_entry.certi_chain[3] = dev_certi;
	certificate_chain_entry.certi_len[3] = sizeof(dev_certi);
	certificate_chain_entry.key_chain[3] = dev_pv;
	sec_certificate_list_update(&certificate_chain_entry);
 * @endcode
 *
 *
 */


/** TLS-PSK Cipher Suite */
#define SEC_SOCKET_CIPHERSUITE_PSK 1
/** TLS-ECC Cipher Suite */
#define SEC_SOCKET_CIPHERSUITE_ECC 2


/**
 * \brief SET socket TLS chipher Suite support
 *
 * This function set socket TLS chiphersuite list. Library support PSK & ECC. Default is PSK
 *
 * \param socket socket id
 * \param security_suites Chipher suite list (SEC_SOCKET_CIPHERSUITE_PSK , SEC_SOCKET_CIPHERSUITE_ECC)
 *
 * \return 0 done
 * \return -1 invalid socket id
 * \return -2 Invalid Security Suite
 */
extern int8_t sec_socket_set_chipher_suite_list(uint8_t socket_id, uint8_t security_suites);
#ifdef __cplusplus
}
#endif
#endif /* SOCKET_SECURITY_H_ */
