/*
 * \file arm_hal_phy.h
 * \brief Add short description about this file!!!
 * Copyrigth ARM Ltd 2013
 *
 */

#ifndef ARM_HAL_PHY_H_
#define ARM_HAL_PHY_H_
 #ifdef __cplusplus
extern "C" {
#endif
typedef enum
{
	PHY_INTERFACE_RESET, 			/**< Reset PHY driver and set to idle */
	PHY_INTERFACE_DOWN, 			/**< Disable PHY Interface driver (RF radio disable) */
	PHY_INTERFACE_UP, 				/**< Enable PHY Interface driver (RF radio receiver ON) */
	PHY_INTERFACE_RX_ENERGY_STATE, /**< Enable wirless interface ED scan mode */
} phy_interface_state_e;


typedef enum
{
	PHY_LINK_TX_DONE, 			/**< TX process Ready and ACK RX */
	PHY_LINK_TX_DONE_PENDING,	/**< TX process OK with ACK pending flag*/
	PHY_LINK_TX_SUCCESS, 		/**< MAC TX complete MAC will make decission to enter wait ack or TX Done state*/
	PHY_LINK_TX_FAIL, 			/**< Link TX process fail*/
	PHY_LINK_CCA_FAIL,			/**< RF Link CCA process fail */
} phy_link_tx_status_e;


typedef enum
{
	PHY_EXTENSION_CTRL_PENDING_BIT, /**< Control MAC Pending Bit for INDirect data */
	PHY_EXTENSION_READ_LAST_ACK_PENDING_STATUS, /**< Control MAC Pending Bit for INDirect data */
	PHY_EXTENSION_SET_CHANNEL, 	/**< Net librarys channel set */
	PHY_EXTENSION_READ_CHANNEL_ENERGY, /**< RF interfacen ED scan energy read */
	PHY_EXTENSION_READ_LINK_STATUS, /**< Net library could read link status*/
} phy_extension_type_e;

typedef enum
{
	PHY_MAC_48BIT, /**< IPv4/IPv6/BLE link layer address for ethernet this optional */
	PHY_MAC_64BIT, /**< RF / PLC link layer address*/
	PHY_MAC_16BIT, /**< RF interface short address*/
	PHY_MAC_PANID, /**< RF interface 16-Bit PAN-ID*/
} phy_address_type_e;

typedef enum phy_link_type_e
{
	PHY_LINK_ETHERNET_TYPE,			/**< Standard IEEE 802 Ethernet */
	PHY_LINK_15_4_2_4GHZ_TYPE,		/**< Standard 802.15.4 2.4GHz radio */
	PHY_LINK_15_4_SUBGHZ_TYPE,		/**< Standard 802.15.4 subGHz radio 868 /915MHz */
	PHY_LINK_SW_RADIO_TYPE, 		/**< Proprietary radio Frequency controlled by SW */
	PHY_LINK_FHSS_TYPE, 			/**< Frequency Hopper system radio link*/
	PHY_LINK_BLE_TYPE, 				/**< Bluetooth Radio link*/
	PHY_LINK_PLC_TYPE, 				/**< PLC PHY link*/
	PHY_LINK_WIFI_2_4GHZ_TYPE,		/**< WIFI 2.4GHz radio link*/
	PHY_LINK_WIFI_5GHZ_TYPE,		/**< WIFI 5GHz radio link*/
	PHY_LINK_WIFI_MULTI_BAND_TYPE, 	/**< WIFI 2.4GHz/5GHz radio link*/
	PHY_LINK_TUN,					/**< Linux TUN interface or similiar */
} phy_link_type_e;


typedef struct phy_device_channel_info_s
{
	uint8_t channel_count; 		/**< Define how many channels is available */
	uint32_t channel_mask; 		/**< Define 27 channels for 802.15.4 radios */
}phy_device_channel_info_s;


typedef struct phy_device_driver_s
{
	phy_link_type_e link_type; 										/**< Define link driver types */
	uint8_t *PHY_MAC ;												/**< Pointer to 64-bit or 48-bit MAC address */
	char * driver_description; 										/**< Short driver platform description. Need end to zero */
	uint16_t phy_MTU; 												/**< Define MAX PHY layer MTU size */
	uint8_t phy_tail_length;						        		/**< Define PHY driver needed TAIL Length */
	uint8_t phy_header_length;										/**< Define PHY driver needed Header length before PDU */
	int8_t (*phy_xx_state_control)(phy_interface_state_e, uint8_t); /**< Function pointer for control PHY driver state */
	int8_t (*phy_xx_tx)(uint8_t *,uint16_t,uint8_t);				/**< Function pointer for  PHY driver write operation */
	int8_t (*phy_xx_address_write)(phy_address_type_e ,uint8_t *);	/**< Function pointer for  PHY driver address write */
	int8_t (*phy_xx_extension)(phy_extension_type_e,uint8_t *);		/**< Function pointer for  PHY driver extension control */
	phy_device_channel_info_s *link_channel_info;					/**< Pointer for wireless channel info */
}phy_device_driver_s;


/** Net Library PHY Interface API*/
/**
 * \brief This function register device driver to stack.
 *
 * \param phy_driver pointer to device driver structure
 *
 * \return >= 0 Device driver ID
 * \return < 0 Means register Fail
 *
 */
extern int8_t arm_net_phy_register(phy_device_driver_s *phy_driver);

/**
 * \brief This function is API for DATA RX to stack
 *
 * \param data_ptr pointer to data
 * \param data_len data len
 * \param link_quality radio link quality
 * \param interface_id device driver ID. That define stack handler
 * \return >= 0 Data RX OK
 * \return < 0 Data push Fail
 *
 */
extern int8_t arm_net_phy_rx(uint8_t *data_ptr, uint16_t data_len, uint8_t link_quality, int8_t interface_id);
/**
 * \brief This function is API for Indicate device driver write operation is done
 *
 * \param interface_id device driver ID
 * \param tx_handle Unique Handle for packet
 * \param status define TX process status
 * \param cca_retry CCA attemps count for this TX process
 * \param tx_retry TX retry count for this packet
 *
 * \return >= 0 Process OK
 * \return < 0 Process handler Fail
 *
 */
extern int8_t arm_net_phy_tx_done(int8_t interface_id, uint8_t tx_handle, phy_link_tx_status_e status, uint8_t cca_retry, uint8_t tx_retry);

 #ifdef __cplusplus
}
#endif
#endif /* ARM_HAL_PHY_H_ */
