/*
 * \file arm_hal_interrupt.h
 * \brief Add short description about this file!!!
 * Copyrigth ARM Ltd 2013
 *
 */

#ifndef ARM_HAL_API_H_
#define ARM_HAL_API_H_
#ifdef __cplusplus
extern "C" {
#endif
#include <stdint.h>

/**
 * \brief This function disable global interrupts.
 */
extern void arm_enter_critical(void);
/**
 * \brief This function enable global interrupts.
 */
extern void arm_exit_critical(void);

/**
 * \brief This function will be called when stack enter idle state and start waiting signal.
 */
extern void hal_event_os_wait(void);

/**
 * \brief This function will be called when stack receive event and could wake from idle.
 */
extern void hal_event_os_signal(void);

/**
 * \brief This function will be called when stack can enter deep sleep state in detected time.
 */
extern uint32_t hal_event_os_sleep(uint32_t sleep_time_ms);

#define sys_critical_enter(x) arm_enter_critical()
#define sys_critical_exit(x) arm_exit_critical()
#ifdef __cplusplus
}
#endif

#endif /* ARM_HAL_API_H_ */
