#ifndef _BR_PANA_SERVER_LIB_H
#define _BR_PANA_SERVER_LIB_H
/**
 * \file br_pana_server.h
 * \brief Border Router Pana Security server API.
 *
 * \section br-panainit Initialize API
 * - pana_server_set(), Allocate & Initialize Security server sessions and key material
 * - pana_key_update_delay_set(), Set timeout for new key material use trig.
 *
 * \section br-panaruntime Runtime API
 * - pana_server_key_update(), Trig Key update for new key material
 * - pana_key_update_delay_set(), update current key material delay timer
 * - pana_start_using_new_key(), skip current key trig timeout and start use new material immediately
 * - net_network_key_get(), Read security key material
 *
 * When Pana Server sends a new key to routers they not use key before border router use key first time. Pana server trig new key after configured timeout.
 * Pana server default timeout for trig new key is 120s (120000ms). That time will start ticking down when key delivery to routers is ready.
 *
 */



///**
// * \brief Init Security Server and clean old sessions
// *
// *\param network_key_material pointer to 128-bit Network key material or NULL generate key material randomly
// *\param supported_chipher_suites SEC_SOCKET_CIPHERSUITE_PSK, SEC_SOCKET_CIPHERSUITE_ECC or both of same time
// *
// * \return 0 Pana Server Initialize OK
// * \return -1 Memory Allocation Fail
// */
//extern int8_t pana_server_set(uint8_t * network_key_material, uint8_t supported_chipher_suites);


///*! \fn int8_t pana_start_using_new_key(void);
// *
// *  \brief This function is used to trig new key after delivery.
// *
// *  \return 0 Key trig OK
// */
//int8_t pana_start_using_new_key(void);

#endif

