#ifndef _BR_LIB_H
#define _BR_LIB_H
/**
 * \file br_lib.h
 * \brief Border Router ZigBeeIP border router interface configure API
 *
 *	\section br-ndconf Border Router ND configuration interface API
 *	- border_router_allocate(), Allocate Border Router ND base by configured structure border_router_info_t
 *	- border_router_nd_context_update(), Update ND context Run time and Idle state
 *	- border_router_nd_context_ttl_compress_update(), change context TTL
 *		* valid to call at run time and idle
 *		* Run time border_router_nd_configure_update() need to call before update is valid.
 *	- border_router_nd_context_remove(), remove selected context at run time or idle state
 *		* valid to call at run time and idle
 *		* Run time border_router_nd_configure_update() need to call before update is valid.
 *	- border_router_nd_configure_update(), Update ABRO version number and load new Context setup to ND.
 *		*valid to call at run time
 *  - border_router_interface_up(), Turn on ZigBeeIP wireless interface.
 *  - border_router_interface_down(), disable Wireless interface.
 *
 * \section br-nvm Border Router ND NVM API
 * - border_router_nd_nvm_callback_set(), initialize NVM functionality for ND
 * - border_router_nd_context_load(), Load Saved context to Boarder Router Base
 *
 * \section br-seq Border Router ZigBeeIP wireless interface initialize sequence
 *
 * 1. Define Network Key Material
 * 2. Initialize Pana Server and configure network key material by pana_server_set()
 * 3. Define Border Router link layer, ND to border_router_info_t structure
 * 4. Allocate and Initialize Border Router base by border_router_allocate()
 * 5. Add more contexts than default one by border_router_context_update()
 *		- Default context is always created to context id 0 by default prefix
 * 6. Define RPL setup check net_rpl.h file.
 * 7. Activate ZigBeeIP border router stack by border_router_interface_up()
 * 8. Set RF interface up by br_rf_interface_up()
 * 9. Wait RF_AP_CONF_NWK_UP event response
 *		- call again br_rf_interface_up() if application have been wait over 100ms
 * 10. Interface is up and ready for Wireless communication
 *
 */



/* ND Router Setups  used at br_setups parameter at configure structure*/
//#define ND_DEDAULT_PREFIX_CONTEXT 	1	/* This parameter will enable 6LoWPAN default context for configured Prefix */

///*!
// * \struct border_router_info_t
// * \brief Border Router configuration structure.
// */
//typedef struct
//{
//
//	uint8_t		channel;				/**< Channel for network supported value 11-26*/
//	int8_t 	radio_tx_power;			/**< Radio TX Power in dBm (not used in this release)*/
//	//uint32_t	channel_list;			/**< Channel List for ED scan(not used in this release)*/
//	uint16_t	mac_short_adr;			/**< Link Layer Short Address if not 0xffff or 0xfffe define GP16 and enable short address mode to Link Layer */
//	uint16_t	mac_panid;				/**< Link Layer PAN-id accepts only < 0xfffe  */
//	uint8_t 	mac_security_level;		/**< ZigbeeIP use always 5  */
//	uint8_t 	key_material[16];		/**< Security key material given by PANA Server. ZigBeeIP never uses that field*/
//	uint8_t 	key_id;					/**< Key id given by Pana Server.ZigBeeIP never uses that field */
//	uint8_t 	beacon_protocol_id;		/**< ZigBeeIP use always 2 */
//	uint8_t		network_id[16];			/**< network id 16-bytes, will be used at Beacon payload */
//	uint8_t		gen_prefix[8];			/**< Define ND Default prefix, ABRO, DODAG ID, GP16, GP64 */
//	uint8_t		br_setups;				/**< ND context default Border Router Setups 1 when set default context, 0 when not*/
//	uint16_t 	ra_life_time;			/**< Define ND router lifetime in seconds Recommend values over 180. */
//	uint16_t 	abro_version_num;		/**< ND ABRO version number (0 when start new ND setup) */
//}border_router_info_t;


#endif


