#ifndef _BR_IPV6_LIB_H
#define _BR_IPV6_LIB_H
 #ifdef __cplusplus
extern "C" {
#endif
/**
 * \file br_ipv6_lib.h
 * \brief Border Router IPv6 interface API
 *
 * \section ipv6-api IPv6 interface API
 * - ipv6_MAC_init(), Initialize IPv6 Stack and 48-bit MAC address
 * - ipv6_interface_up(), Enable IPv6 stack Interface
 * - ipv6_interface_down(), Disable IPv6 Interface
 * - ipv6_get_gp_ipv6_address(), Read IPv6 GP address
 *
 * \section ipv6-init IPv6 modules init bootstrap sequence
 * 	1. ipv6_MAC_init(), Init Ethernet MAC.
 * 	2. ipv6_interface_up(), Set IPv6 Global prefix and activate IPv6 stack.
 */

/**
 * \brief Initialize Ethernet MAC and IPv6 base
 *
 * Call only once at bootstrap.
 *
 * \param mac_address pointer to 48-bit MAC address
 *
 * \return 0> Interface ID for IPv6
 * \return -1 Init fail
 *
 */
extern int8_t ipv6_MAC_init(int8_t ethernet_dev_driver_id);

/**
 * \brief Ethernet IPv6 Interface Configure
 *
 * \param interface_address pointer to IPv6 prefix for.
 *
 */
extern int8_t ipv6_interface_up(uint8_t *interface_address);
/**
 * \brief Disable IPv6 protocol stack
 */
extern void ipv6_interface_down(void);

/** Security Server Configure */

/**
 * \brief Get Ethernet interface IPv6 GP address
 *
 * \param address_ptr pointer  where IPv6 address will be saved.
 *
 *
 * \return 0 	Process OK
 * \return -1 	IPv6 stack is at idle
 *
 */
extern int8_t ipv6_get_gp_ipv6_address(uint8_t *address_ptr);
 #ifdef __cplusplus
}
#endif
#endif
