/*
 * \file arm_hal_aes.h
 * \brief This file define Nanostack AES block encoder and AES init function.
 * Copyrigth ARM Ltd 2013
 *
 */

#ifndef ARM_HAL_AES_H_
#define ARM_HAL_AES_H_
 #ifdef __cplusplus
extern "C" {
#endif
/**
 * \brief This function performs Si=E[key,Ai] (Simple OCB block).
 *
 * \param key_ptr pointer to 128-bit AES key
 * \param Ai_ptr pointer to 128-bit data block in
 * \param Si_ptr pointer for encoded sum by key and input data
 *
 */
extern void arm_aes_block_encode(uint8_t * key_ptr , uint8_t * Ai_ptr, uint8_t * Si_ptr);
/**
 * \brief This function initialize AES Hardware.
 */
extern void arm_aes_init(void);
#ifdef __cplusplus
}
#endif
#endif /* ARM_HAL_AES_H_ */
