#include "buzzer.h"
#include "mbed.h"
 

 
using namespace mbed;

    
Beep::Beep(PinName pin) : _pwm(pin) {
    _pwm.write(0.0);     // after creating it have to be off
}
 

void Beep::nobeep() {
    _pwm.write(0.0);
}
 

     
void Beep::beep(float freq, float time) {
 
    _pwm.period(1.0/freq);
    _pwm.write(0.5);            // 50% duty cycle - beep on
    toff.attach(this,&Beep::nobeep, time);   // time to off
}