#ifndef _TABLE_
#define _TABLE_

#include "mbed.h"
class table{
public:
  table(int times);
  ~table();
  void SIN_table(void);
  void COS_table(void);
  void make_table(double (*fnc)(int));
  double show(int num);
  double deg(double degree);
  double rad(double radian);
private:
  int number;
  double *ans;
  double M_PI;
private:
};
#endif
/*
byDONAV___2017/03/19
main関数だけ抜粋
基本的にはｃで書かれたほうのライブラリと使い方は同じだが、ユーザの手数をクラスを用いることによって減らしたバージョンがこれである。

  コンストラクタとデスコントラクタ
コンストラクタの引数はテーブルのサイズまたは、三角関数の精度となる。
デスコントラクタは動的確保した配列の消去を行う。

  メンバ関数の説明
    SIN_table
    正弦の値を動的確保した配列に代入する。

    COS_table
    余弦の値を動的確保した配列に代入する。

    make_table
    ユーザが定義した関数のポインタを引数として、動的確保した配列に代入する。

    show
    基本的にはmake_tableを用いて配列に代入したときに用いる。
    引数の番号の配列の値を返す。

    deg,rad
    基本的にはSIN_tableやCOS_tableを用いて配列に代入したときに用いる。
    引数は、degreeとradianの角度で、角度に対応した配列を返す。

  プログラム例を下に記す。
  #include <stdlib.h>
  #include <stdio.h>
  #include <math.h>
  #include <class_table.h>
  double squad(int n){
    return n*n;
  }
  int main(){
    table sin_ta(1200);
    table cos_ta(1200);
    table sqa_ta(1200);
    sin_ta.SIN_table();
    cos_ta.COS_table();
    sqa_ta.make_table(squad);
    printf("%f",sin_ta.deg(30));
    printf("%f",cos_ta.deg(60));
    for(int i=0;i<1201;i++){
      printf("%f\n",sqa_ta.show(i));
    }
  }


///////////////////////////////////////////////////////////////////////////////
実行結果
0.50000
0.50000
*/
