#include "math.h"
#include "mbed.h"

class table{
public:
  table(int times);
  ~table();
  void SIN_table(void);
  void COS_table(void);
  void make_table(double (*fnc)(int));
  double show(int num);
  double deg(double degree);
  double rad(double radian);
private:
  double M_PI = 3.141592653589793;
  double *ans;
  int number;
};
table::table(int times){
  number = times;
}
table::~table(){
  free(ans);
}
void table::SIN_table(void){
  ans = (double*)malloc(sizeof(double)*number+1);
  //ans = new double[sizeof(double)*number+1];
  if(ans == NULL) exit(1);
  for(int i=0;i<number+1;i++){//[0]~[number]
    ans[i] = sin(M_PI*i*2.0/number);
  }
}
void table::COS_table(void){
  ans = (double*)malloc(sizeof(double)*number+1);
  for(int i=0;i<number+1;i++){
    ans[i] = cos(M_PI*i*2.0/number);
  }
}
void table::make_table(double (*fnc)(int)){
  ans = (double*)malloc(sizeof(double)*number+1);
  for(int i=0;i<number+1;i++){
    ans[i] = fnc(i);
  }
}
double table::show(int num){
  return ans[num];
}
double table::deg(double degree){
  double sa_db=0.0;
  int sa_int=0;
  double degree_abs =0.0;
  int degree_int=0;
  if(degree<0) degree_abs = labs(degree);
  else degree_abs = degree;
  if(degree_abs>360){
    degree_int = degree/360;
    degree = degree - degree_int*360;
  }
  if(degree<0) degree = degree+360;
  sa_db = number*0.5*degree/180;
  sa_int = sa_db;
  return ans[sa_int];
  //return ans[sa_int];
  //return sa_db;
}
double table::rad(double radian){
  double sa_db;
  int sa_int;
  double radian_abs;
  int radian_int;
  radian = radian/M_PI;

  if(radian<0) radian_abs = labs(radian);
  else radian_abs = radian;

  if(radian_abs>2.0){
    radian_int = radian/2.0;
    radian = radian - radian_int*2.0;
  }

  if(radian<0) radian = radian+2.0;

  sa_db = number*radian*0.5;
  sa_int = sa_db;
  sa_db = ans[sa_int];
  return sa_db;
}
