/*
Copyright (c) 2010 Peter Barrett

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "mbed.h"
#include "USBHost.h"
#include "Utils.h"
#include "m3pi.h"
#include "ps3BT.h"

typedef struct {        
     u8 ReportType;     //Report Type 01
     u8 Reserved1;      // Unknown
     u16  ButtonState;    // Main buttons
     u8 PSButtonState;  // PS button
     u8 Reserved2;      // Unknown
     u8 LeftStickX;     // left Joystick X axis 0 - 255, 128 is mid
     u8 LeftStickY;     // left Joystick Y axis 0 - 255, 128 is mid
     u8 RightStickX;    // right Joystick X axis 0 - 255, 128 is mid
     u8 RightStickY;    // right Joystick Y axis 0 - 255, 128 is mid
     u8 Reserved3[4];   // Unknown
     u8 PressureUp;     // digital Pad Up button Pressure 0 - 255
     u8 PressureRight;  // digital Pad Right button Pressure 0 - 255
     u8 PressureDown;   // digital Pad Down button Pressure 0 - 255
     u8 PressureLeft;   // digital Pad Left button Pressure 0 - 255
     u8 PressureL2;     // digital Pad L2 button Pressure 0 - 255
     u8 PressureR2;     // digital Pad R2 button Pressure 0 - 255
     u8 PressureL1;     // digital Pad L1 button Pressure 0 - 255
     u8 PressureR1;     // digital Pad R1 button Pressure 0 - 255
     u8 PressureTriangle;   // digital Pad Triangle button Pressure 0 - 255
     u8 PressureCircle;     // digital Pad Circle button Pressure 0 - 255
     u8 PressureCross;      // digital Pad Cross button Pressure 0 - 255
     u8 PressureSquare;     // digital Pad Square button Pressure 0 - 255
     u8 Reserved4[3];   // Unknown
     u8 Charge;         // charging status ? 02 = charge, 03 = normal
     u8 Power;          // Battery status ?
     u8 Connection;     // Connection Type ?
     u8 Reserved5[9];   // Unknown
     u16 AccelX;          // X axis accelerometer Big Endian 0 - 1023
     u16 AccelY;          // Y axis accelerometer Big Endian 0 - 1023
     u16 AccelZ;          // Z axis accelerometer Big Endian 0 - 1023
     u16 GyroZ;           // Z axis Gyro Big Endian 0 - 1023
    
} ps3report;

Serial pc(USBTX, USBRX);
m3pi m3pi;

void PS3_data(const u8* data) {
    float speed;
    ps3report* _ps3report = (ps3report*)data;
    PS3BT ps3;
    ps3.decode(data);
    ps3.dump(data);
    if(100 <= _ps3report->LeftStickY && _ps3report->LeftStickY <= 155)
        {
            m3pi.stop();
        } else if(0 <= _ps3report->LeftStickY && _ps3report->LeftStickY <= 99) {
            speed = (100 - _ps3report->LeftStickY) * 0.01;
            m3pi.left_motor(speed);
            printf("A:%f", speed);
        } else {
            speed = (155 - _ps3report->LeftStickY) * 0.01;
            m3pi.left_motor(speed);
            printf("A:%f", speed);
        }
        
        if(100 <= _ps3report->RightStickY && _ps3report->RightStickY <= 155)
        {
            m3pi.stop();
        } else if(0 <= _ps3report->RightStickY && _ps3report->RightStickY <= 99) {
            speed = (100 - _ps3report->RightStickY) * 0.01;
            m3pi.right_motor(speed);
            printf("B:%f", speed);
        } else {
            speed = (155 - _ps3report->RightStickY) * 0.01;
            m3pi.right_motor(speed);
            printf("B:%f", speed);
        }
    
    
    
}
int main()
{
    pc.baud(230400);
    
    m3pi.locate(0,1);
    m3pi.printf("M3pi - PS3");
    
    USBInit();
    
    while(1){
    USBLoop();
    }
}
