#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"

uLCD_4DGL uLCD(p9, p10, p11); // create a global lcd object
//ADXL345 accelerometer(p5, p6, p7, p8);//create a global accelerometer object
Serial pc(USBTX, USBRX);// for debugging
Mutex lcd_mutex;// Create the mutex lock object
//PwmOut speaker(p21); //create a PwmOut object for the speaker
//SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
AnalogIn jsx(p19);
//AnalogIn jsy(p20);

int playerx, playery, ob1x, ob1y, ob2x, ob2y, ob3x, ob3y;
int x=0,y=0;
double obwait=0.2;

void thread1(void const *args){
    //generates obstacles
    while(true){
        
        //lcd_mutex.lock();//acquire lock
        /*if(ob1y>127 && playerx==26){
            ob1x=26;
            //ob1y=-16;
            ob1y=0;
        }
        
        if(ob2y>127 && playerx==58){
            ob2x=58;
            //ob2y=-16;
            ob2y=0;
        }
        
        if(ob3y>127 && playerx==90){
            ob3x=90;
            //ob3y=-16;
            ob3y=0;
        }*/
        
        lcd_mutex.lock();//acquire lock
        uLCD.filled_rectangle(ob1x,ob1y,ob1x+15,ob1y+15,0x000000);//erase previous position
        ob1y=ob1y+16;
        
        uLCD.filled_rectangle(ob2x,ob2y,ob2x+15,ob2y+15,0x000000);//erase previous position
        ob2y=ob2y+16;
        
        uLCD.filled_rectangle(ob3x,ob3y,ob3x+15,ob3y+15,0x000000);//erase previous position
        ob3y=ob3y+16;
        
        if(ob1y>127 && playerx==26){
            ob1x=26;
            //ob1y=-16;
            ob1y=16;
        }
        
        if(ob2y>127 && playerx==58){
            ob2x=58;
            //ob2y=-16;
            ob2y=16;
        }
        
        if(ob3y>127 && playerx==90){
            ob3x=90;
            //ob3y=-16;
            ob3y=16;
        }
        
        
        //for(x=0;x<10;x++){
        uLCD.filled_rectangle(ob1x,ob1y,ob1x+15,ob1y+15,0xFF3300);//change position
        uLCD.filled_rectangle(ob2x,ob2y,ob2x+15,ob2y+15,0xFF3300);//change position
        uLCD.filled_rectangle(ob3x,ob3y,ob3x+15,ob3y+15,0xFF3300);//change position
        //}
        
        lcd_mutex.unlock();//release lock
        
        y++;
        if(y%50==0)
          obwait=(obwait/2);
        if(obwait<0.0005)
          obwait=0.0005;
        pc.printf("y=%d\nobwait=%f\n", y, obwait);
        
        lcd_mutex.lock();
        
        uLCD.text_width(1); //4X size text
        uLCD.text_height(1);
        uLCD.locate(0,0);
        uLCD.set_font(FONT_7X8);
        uLCD.text_mode(OPAQUE);
        uLCD.printf("Sc=%d",y);
        uLCD.locate(10,0);
        uLCD.printf("Sp=%d",((y/50)+1));
        
        lcd_mutex.unlock();
        
        wait(obwait);
    }
}    



        
int main(){
    float jx;
    uLCD.cls();// clear the LCD
    
    uLCD.text_width(2); //2X size text
    uLCD.text_height(2);
    
    
    uLCD.locate(0,2);
    
    uLCD.printf("\nAuto Race\n");//display the Title
    wait(5);   
    
    uLCD.cls();
    
    ob1x=26;
    ob1y=140;
        
    ob2x=58;
    ob2y=140;
        
    ob3x=90;
    ob3y=140;
    
    playerx=58;
    playery=112;
    
    uLCD.filled_rectangle(playerx,playery,playerx+15,playery+15,0x0000FF);
    
    uLCD.filled_rectangle(110,16,116,127,0xFFFF00);
    uLCD.filled_rectangle(15,16,21,127,0xFFFF00);
    
    uLCD.filled_rectangle(116,16,127,127,0x009900);
    uLCD.filled_rectangle(0,16,15,127,0x009900);
    
    uLCD.line(0,15,127,15,0xFFFF00);
    
    //uLCD.line(81.5,0,81.5,12,WHITE);
    //uLCD.line(48.5,0,48.5,12,WHITE);
    
    uLCD.line(81.5,16,81.5,28,WHITE);
    uLCD.line(48.5,16,48.5,28,WHITE);
    
    uLCD.line(81.5,32,81.5,44,WHITE);
    uLCD.line(48.5,32,48.5,44,WHITE);
    
    uLCD.line(81.5,48,81.5,60,WHITE);
    uLCD.line(48.5,48,48.5,60,WHITE);
    
    uLCD.line(81.5,64,81.5,76,WHITE);
    uLCD.line(48.5,64,48.5,76,WHITE);
    
    uLCD.line(81.5,80,81.5,92,WHITE);
    uLCD.line(48.5,80,48.5,92,WHITE);
    
    uLCD.line(81.5,96,81.5,108,WHITE);
    uLCD.line(48.5,96,48.5,108,WHITE);
    
    uLCD.line(81.5,112,81.5,124,WHITE);
    uLCD.line(48.5,112,48.5,124,WHITE);
    
    Thread t1(thread1);
    
    while(true){
        jx=jsx;
        pc.printf("%f\n",jx);
        if(playerx == 58){
            lcd_mutex.lock();//acquire lock
            uLCD.filled_rectangle(playerx,playery,playerx+15,playery+15,0x000000);
            lcd_mutex.unlock();//release lock
            if(jsx>.9){
                playerx+=32;
            }
            else if(jsx<.1){
                playerx-=32;
            }
            lcd_mutex.lock();//acquire lock
            uLCD.filled_rectangle(playerx,playery,playerx+15,playery+15,0x0000FF);
            lcd_mutex.unlock();//release lock
            //wait(0.5);
        }
        
/*        if((playerx==ob1x && playery==ob1y) || (playerx==ob2x && playery==ob2y) || (playerx==ob3x && playery==ob3y)){
        //if((playerx==ob3x && playery==ob3y)){

        //if((playerx==ob1x) || (playerx==ob2x) || (playerx==ob3x)){    
            thread2.signal_set(0x1);
            lcd_mutex.lock();
            uLCD.cls();
       
            uLCD.text_width(2); //2X size text
            uLCD.text_height(2);
            uLCD.color(RED);
            uLCD.locate(2,2);
            uLCD.printf("\n   GAME \n   OVER!\n");
            wait(2);
            break;
            
            uLCD.cls();
            wait(2);
            lcd_mutex.unlock();
            
        }
  */      
        else if(playerx == 26){
            lcd_mutex.lock();//acquire lock
            uLCD.filled_rectangle(playerx,playery,playerx+15,playery+15,0x000000);
            lcd_mutex.unlock();//release lock
            if(jsx>.9){
                playerx+=32;
            }
            lcd_mutex.lock();//acquire lock
            uLCD.filled_rectangle(playerx,playery,playerx+15,playery+15,0x0000FF);
            lcd_mutex.unlock();//release lock
            //wait(0.5);
        }
            
        

        
 /*       if((playerx==ob1x && playery==ob1y) || (playerx==ob2x && playery==ob2y) || (playerx==ob3x && playery==ob3y)){
        //if((playerx==ob3x && playery==ob3y)){

        //if((playerx==ob1x) || (playerx==ob2x) || (playerx==ob3x)){    
            lcd_mutex.lock();
            uLCD.cls();
       
            uLCD.text_width(2); //2X size text
            uLCD.text_height(2);
            uLCD.color(RED);
            uLCD.locate(2,2);
            uLCD.printf("\n   GAME \n   OVER!\n");
            wait(2);
            break;
            
            uLCD.cls();
            wait(2);
            lcd_mutex.unlock();
            
        }
   */           
        else if(playerx==90) {
            lcd_mutex.lock();//acquire lock
            uLCD.filled_rectangle(playerx,playery,playerx+15,playery+15,0x000000);
            lcd_mutex.unlock();//release lock
            if(jsx<.1){
                playerx-=32;
                }
            lcd_mutex.lock();//acquire lock
            uLCD.filled_rectangle(playerx,playery,playerx+15,playery+15,0x0000FF);
            lcd_mutex.unlock();//release lock
            //wait(0.5);
        }                
        //lcd_mutex.lock();
        if((playerx==ob1x && playery==ob1y) || (playerx==ob2x && playery==ob2y) || (playerx==ob3x && playery==ob3y)){
            lcd_mutex.lock();
            uLCD.cls();
       
            uLCD.text_width(2); //2X size text
            uLCD.text_height(2);
            uLCD.color(RED);
            uLCD.locate(2,2);
            uLCD.printf("\n  GAME \n  OVER!\n");
            wait(2);
            uLCD.cls();
            uLCD.text_width(2); //2X size text
            uLCD.text_height(2);
            uLCD.locate(2,2);
            uLCD.printf("\nScore=%d\n",y);
            
            break;
            
            uLCD.cls();
            wait(2);
            lcd_mutex.unlock();
            
        }
        /*if((playerx==ob2x && playery==ob2y)){
        //if((playerx==ob3x && playery==ob3y)){

        //if((playerx==ob1x) || (playerx==ob2x) || (playerx==ob3x)){    
            lcd_mutex.lock();
            uLCD.cls();
       
            uLCD.text_width(2); //2X size text
            uLCD.text_height(2);
            uLCD.color(RED);
            uLCD.locate(2,2);
            uLCD.printf("\n   GAME \n   OVER!\n");
            wait(2);
            break;
            
            uLCD.cls();
            wait(2);
            lcd_mutex.unlock();
            
        }
        if((playerx==ob3x && playery==ob3y)){
        //if((playerx==ob3x && playery==ob3y)){

        //if((playerx==ob1x) || (playerx==ob2x) || (playerx==ob3x)){    
            lcd_mutex.lock();
            uLCD.cls();
       
            uLCD.text_width(2); //2X size text
            uLCD.text_height(2);
            uLCD.color(RED);
            uLCD.locate(2,2);
            uLCD.printf("\n   GAME \n   OVER!\n");
            wait(2);
            break;
            
            uLCD.cls();
            wait(2);
            lcd_mutex.unlock();
            
        }*/
    }
}     