#include "mbed.h"
#include <string>
#include "mbed.h"
#include "uLCD_4DGL.h"
#include <string>
#include <ctype.h>
#include "SDFileSystem.h"
#include "wave_player.h"
RawSerial  dev(p28,p27);//bluetooth
SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board
AnalogOut DACout(p18);//speaker
wave_player waver(&DACout);//wave player
int x1=0;
int y1=11;
//nav switch class for joystick
class Nav_Switch
{
public:
    Nav_Switch(PinName up,PinName down,PinName left,PinName right,PinName fire);
    int read();
//boolean functions to test each switch
    bool up();
    bool down();
    bool left();
    bool right();
    bool fire();
    
//automatic read on RHS
    operator int ();
//index to any switch array style
    bool operator[](int index) {
        return _pins[index];
    };
private:
    BusIn _pins;
 
};
Nav_Switch::Nav_Switch (PinName up,PinName down,PinName left,PinName right,PinName fire):
    _pins(up, down, left, right, fire)
{
    _pins.mode(PullUp); //needed if pullups not on board or a bare nav switch is used - delete otherwise
    wait(0.001); //delays just a bit for pullups to pull inputs high
}
//sets up navigation switch
inline bool Nav_Switch::up()
{
    
    return !(_pins[0]);
}
inline bool Nav_Switch::down()
{
     
    return !(_pins[1]);
}
inline bool Nav_Switch::left()
{
    
    return !(_pins[2]);
}
inline bool Nav_Switch::right()
{
     
    return !(_pins[3]);
}
inline bool Nav_Switch::fire()
{
     
    return !(_pins[4]);
}
inline int Nav_Switch::read()
{
    return _pins.read();
}
inline Nav_Switch::operator int ()
{
    return _pins.read();
}
 
Nav_Switch myNav( p26, p23, p24, p22, p25); //pin order on Sparkfun breakout


uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;
int alphabet[26];
int x=0;
int category;
int word; 
string word1;//string  of word
string category1;//category
string words;
string words1;
int numletters=0;//num letters in the phrase/word
char letter;
string chosenLetters;//string of chosen letters
int lives=6;//you get 6 lives


//device receive. this is so the device receives instructions
void dev_recv()
{
    
    if(x>0&&x<3){
        
        
        if(x==1){//x ==1 refers to phase 1 where you get category
            
            category=dev.getc();//used to get category
            if(category==10)//this is to show end line
            {
             x=2;//move on to next phase
             }
             else{
             category1=category1+char(category);//appends letter for category
           
          }

         }
            
        
        else//refers to phase 2 where you get the word/phase
            {
              
                  
            word=dev.getc();//gets word/phrase from device
            if(word==10)//end line
            {
             x=3;
             }
             else{
             word1=word1+char(word);//append characters
        
          }
                  
                  
                  
                  
  
                }
            
    }
}
//prints the sentence/word/phrase using _ 
void printSentence()
{
    string space=" ";
    numletters=word1.length();
    for(int i=0;i<word1.length();i++)
    {
        
        if(int(word1[i])!=32)
        {
        words=words+"_ ";
        words1=words1+word1[i]+" ";

        }
        else
        {
            words=words+"\n";
            words1=words1+"\n";
            numletters--;//if space, decrease num letters
            }
        
        //words1=words1+word1[i]+" ";
        }
        uLCD.locate(0,3);
        uLCD.printf("%s",words);

    }

//this is if you win
void youWon()
{
    uLCD.cls();
    uLCD.printf("You Win! \n");
    uLCD.printf("The word/phrase \nwas:\n%s",word1);
    mkdir("/sd/mydir", 0777);
    
    FILE *fp = fopen("/sd/win.wav", "r");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    //fprintf(fp, "Hello fun SD Card World!");
    waver.play(fp);
    fclose(fp); 
    while(1)
    {
        wait(.1);
        }
    }
    //this is if you lose
    void youLose()
    {
    uLCD.cls();
    uLCD.printf("You Lose! \n");
    uLCD.printf("The word/phrase \nwas:\n%s",word1);
    mkdir("/sd/mydir", 0777);
    
    FILE *fp = fopen("/sd/lose.wav", "r");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    //fprintf(fp, "Hello fun SD Card World!");
    waver.play(fp);
    fclose(fp); 
    while(1)
    {
        wait(.1);
        }
    
        }
        
//draws hangman. draws more parts depending on number lives left
void drawHangman()
{
 
uLCD.line(93, 127, 127, 127, 0xFF0000);
uLCD.line(103, 127, 103, 90, 0xFF0000);
uLCD.line(103, 90, 115, 90, 0xFF0000);
uLCD.line(115, 90, 115, 94, 0xFF0000);
if(lives==5){
uLCD.circle(115, 99, 5, RED);uLCD.circle(115, 99, 5, RED);}//head
else if(lives==4){
 uLCD.line(115, 104, 115, 119, 0xFF0000);}//body
 else if(lives==3){
 uLCD.line(107, 107, 115, 111, 0xFF0000);}//arm
 else if(lives==2){
 uLCD.line(123, 107, 115, 111, 0xFF0000);}//arm2
 else if(lives==1){
uLCD.line(107, 125, 115, 119, 0xFF0000);}//leg
else if(lives==0){
 uLCD.line(123, 125, 115, 119, 0xFF0000);//leg2
 youLose();//calls youlose if you lost
 }
    }

//this is when the person chooses a letter.  
void chooseLetter(char y)
{           //puts the letter in the alphabet array equal to a space so we know it has been used
            if(y1==11){
            alphabet[(y1-11)*x1+x1]=32;
            }
         else{
             alphabet[(y1-12)*x1+x1+13]=32;
             }
             
    
    bool isThere=false;//checks if the letter is there
    for(int i=0;i<words1.length();i++)
    {
        
        if(int(y)==tolower(int(words1[i])))//changes letters to lower case
        {
            isThere=true;
            numletters--;
            words[i]=words1[i];
            
            }
            
        
        }
                uLCD.locate(0,3);
        uLCD.printf("%s",words);//prints _ for each letter now with filled in letters
        if(numletters==0)
        {
           youWon();//if no more letters, you win
        }
        chosenLetters= chosenLetters+y;//this is the list of letters you already chose 
    //this is for setting up the already chosen list
    uLCD.locate(0,14);
    int yc=14;
    for(int i=0;i<chosenLetters.length();i++)
    {
        
    if(i>12)
    {
        yc=15;
    }
        
    uLCD.locate((i%13),yc);
    uLCD.printf("%c",chosenLetters[i]);//prints out letters you already chose
    
}
if(isThere==false)//if the letter isnt there, lose a life, redraw hangman
{lives--;
 drawHangman();
 
}
            //this puts the white space on a different letter
            if(x1==12){
                x1=0;
                if(y1==11){
                y1=12;}
                else
                    y1=11;
                }
            else {
                x1++;}
                

   
    }
    

//this sets the joystick movement up
void joystick()
{
        int i;
      
        i = ~(myNav); //update leds with nav switch direction inputs
        i=i+32;
        
        //this makes the chosen letter up
        if(i==1)
        {
            if(y1==12)
                y1=11;
            else
                y1=12;
                
            }
            
            
        //goes down
        else if(i==2)
        {
            if(y1==11)
                y1=12;
            else
                y1=11;
            
            }
        //goes left
        else if(i==4)
        {
            if(x1==0){
                x1=12;
                }
            else{
                x1--;
            }

                
            }
        //goes right
        else if(i==8)
        {
            if(x1==12)
                x1=0;
            else 
                x1++;

        }
        //select letter
        else if(i==16)
        {
                //following code basically to choose if you will check if the letter is there or not(if you already chose the letter before, you cant choose again)
                uLCD.locate(0,10);
                
    uLCD.color(WHITE);
    bool done=true;
    int choose;
    if(chosenLetters.length()>0){
    for(int i=0;i<chosenLetters.length();i++){
        if(y1==11){
            choose=(y1-11)*x1+x1+97;
                if(char((y1-11)*x1+x1+97)==chosenLetters[i])
                {    
                     done=false;
                    }
                    
                    }
        else
            {
            choose=(y1-12)*x1+x1+97+13;
            if(char((y1-12)*x1+x1+97+13)==chosenLetters[i])
                {
                    done=false;}
            }
            }
            if(done)
            {
                chooseLetter(char(choose));
            }
                
      }      
        else
        {
            if(y1==11)
            chooseLetter(char((y1-11)*x1+x1+97));
            else
             chooseLetter(char((y1-11)*x1+x1+97+13));
            }
            }
            
        uLCD.locate(0,0);

        wait(0.05);
        
}
//this draws the letters that you can choose from and letters chosen
void drawLetters()
{ 
    //sets up location 
    uLCD.locate(0,10);
    uLCD.printf("Choose one:");
    uLCD.locate(0,13);
    uLCD.printf("Chosen:");
    uLCD.locate(0,11);
    
    int ya=11;
        for(int i=0;i<26;i++)
    {
        
    if(i>12)
    {
        ya=12;
    }
    //makes background black and letter white if not chosen
    if(ya==y1&&((i%13)==x1)){
    uLCD.textbackground_color(WHITE);
    uLCD.color(BLACK);
    }
    //makes background white and letter black if chosen
    else
    {
        uLCD.textbackground_color(BLACK);
         uLCD.color(WHITE);
        }
    //prints the alphabet
    uLCD.locate((i%13),ya);
    uLCD.printf("%c",alphabet[i]);
            uLCD.textbackground_color(BLACK);
         uLCD.color(WHITE);
    }

    }
int main()
{
    //clears screan
uLCD.cls();
       
        
    uLCD.color(WHITE);
    for(int i=0;i<26;i++)
    {
        alphabet[i]=i+97;
        }


    uLCD.baudrate(3000000); //jack up baud rate to max for fast display
    
    dev.baud(9600); 
    dev.attach(&dev_recv, Serial::RxIrq);
    //tells player with mbed to start game
    uLCD.printf("You are now starting a game of Hangman. Your friend is choosing a category and phrase");
    x=1;
   //tells player with device to start game
    dev.printf("You are now starting a game of Hangman with your friend \n");
    wait(.1);
    //tells player with device to choose category
    dev.printf("Please enter a category and press enter");
     
      //phase 1(choose category) waiting
    while((x==1)){
        wait(.1);
        }
        
        //clear lcd
     uLCD.cls();
     //draw hangman
      drawHangman();
    uLCD.printf("Category/Hint:\n%s",category1);
    //tells player with device to choose word/phrase
    dev.printf("Please enter a word/phrase and press enter");

   
    //phase 2(choose word) 
    while(x==2) {
   wait(.1);     
    }
    //print sentence
    printSentence();
    //loop
    while(1){
    
    //draws letters 
    drawLetters();
        //check joystick
    joystick();
    }
    //chooseLetter('a');
    //joystick();

     
}
