/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"

#include <stdio.h>
#include "BMP180.h"

I2C i2c(I2C_SDA, I2C_SCL);
BMP180 bmp180(&i2c);

// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    2000

DigitalOut  my_led(LED1);
DigitalOut  pin_out(D8);
InterruptIn my_button(USER_BUTTON);
PwmOut      my_pwm(D9);
AnalogIn adc_temp(ADC_TEMP);


void pressed()
{
    printf("SDA %d\r\n", I2C_SDA);
    printf("SDA %d\r\n", I2C_SCL);
    if (my_pwm.read() < 1.0) {
        my_pwm.write(my_pwm.read() + 0.1);
        if (my_pwm.read() > 1.0) {
            my_pwm.write(1.0);
            printf("pwm set to 100 %\n");
        } else {
            printf("pwm set to %.2f %%\n", my_pwm.read() * 100);
        }
    } else {
        my_pwm.write(0);
        printf("pwm set to 0 %\n");
    }
    wait(0.1);
    return;
}

void BMP180_GetAll (int oss)
{
    bmp180.startTemperature();
    wait_ms(5);     // Wait for conversion to complete
    float temp;
    if(bmp180.getTemperature(&temp) != 0) {
        printf("Error getting temperature\n");
        return;
    }

//    bmp180.startPressure(BMP180::ULTRA_LOW_POWER);
//    bmp180.startPressure(BMP180::STANDARD);
    bmp180.startPressure(BMP180::ULTRA_HIGH_RESOLUTION);
    wait_ms(80);    // Wait for conversion to complete
    int pressure;
    if(bmp180.getPressure(&pressure) != 0) {
        printf("Error getting pressure\n");
        return;
    }

    float altitude;
    altitude = 44330*(1-(pow(((float)pressure/101325.0), 0.19029495718)));

    printf("Pressure = %d Pa | Temperature = %.2f C | Altitude = %f\n", pressure, temp, altitude);
}

int main()
{
     while(1) {
        bmp180.reset();
        if (bmp180.init() != 0) {
            printf("Error communicating with BMP180\n");
        } else {
            printf("Initialized BMP180\n");
            break;
        }
        wait(1);
    }
    
    // Initialise the digital pin LED1 as an output
    printf("Blinking rate %d\r\n", BLINKING_RATE_MS);
    my_pwm.period_ms(10);                                       
    my_pwm.write(1.0);                                          
    float fPower = my_pwm.read() * 100L;
    printf("pwm set to %.2f\r\n", fPower);
    
    float f_Temperature;

    // Set button
    my_button.rise(&pressed);    
    
    while (true) {
        BMP180_GetAll(0);

        f_Temperature = (adc_temp.read()*100);
        printf("ADC Temp = %f \r\n", f_Temperature);


        my_led = !my_led;
        pin_out = !pin_out;
        printf("Blinking rate %d\r\n", my_led);
        wait(BLINKING_RATE_MS / 1000);
    }
}
