#include "mbed.h"
#include "main.h"
/*
   This basic example just shows how to read the ADC internal channels raw values.
   Please look in the corresponding device reference manual for a complete
   description of how to make a temperature sensor, VBat or Vref measurement.
*/

AnalogIn adc_temp(ADC_TEMP);
AnalogIn adc_vref(ADC_VREF);
#if defined(TARGET_DISCO_F051R8) || defined(TARGET_NUCLEO_F030R8) || defined(TARGET_NUCLEO_F031K6) || defined(TARGET_NUCLEO_F042K6) || defined(TARGET_NUCLEO_F070RB) || defined(TARGET_NUCLEO_F072RB) || defined(TARGET_NUCLEO_F091RC) || defined(TARGET_NUCLEO_F207ZG) || defined(TARGET_NUCLEO_F302R8) || defined(TARGET_NUCLEO_F303K8) || defined(TARGET_DISCO_F303VC) || defined(TARGET_NUCLEO_F303RE) || defined(TARGET_NUCLEO_F303ZE) || defined(TARGET_DISCO_F334C8) || defined(TARGET_NUCLEO_F334R8) || defined(TARGET_MTS_DRAGONFLY_F411RE) || defined(TARGET_MTS_MDOT_F405RG) || defined(TARGET_MTS_MDOT_F411RE) || defined(TARGET_DISCO_F401VC) || defined(TARGET_NUCLEO_F401RE) || defined(TARGET_ARCH_MAX) || defined(TARGET_DISCO_F407VG) || defined(TARGET_NUCLEO_F410RB) || defined(TARGET_ELMO_F411RE) || defined(TARGET_NUCLEO_F411RE) || defined(TARGET_NUCLEO_F412ZG) || defined(TARGET_DISCO_F413ZH) || defined(TARGET_DISCO_F429ZI) || defined(TARGET_NUCLEO_F429ZI) || defined(TARGET_NUCLEO_F439ZI) || defined(TARGET_B96B_F446VE) || defined(TARGET_NUCLEO_F446RE) || defined(TARGET_NUCLEO_F446ZE) || defined(TARGET_DISCO_F469NI) || defined(TARGET_DISCO_F746NG) || defined(TARGET_NUCLEO_F746ZG) || defined(TARGET_NUCLEO_F756ZG) || defined(TARGET_NUCLEO_F767ZI) || defined(TARGET_DISCO_F769NI) || defined(TARGET_DISCO_L072CZ_LRWAN1) || defined(TARGET_NUCLEO_L432KC) || defined(TARGET_DISCO_L476VG) || defined(TARGET_NUCLEO_L476RG) || defined(TARGET_NUCLEO_L486RG) 
AnalogIn adc_vbat(ADC_VBAT); // Warning: Not available on all devices
#endif

DigitalOut led(LED1);
AnalogIn analog_light_sensor_read(A1);
//DigitalIn digital_light_sensor_read(D7);
InterruptIn digital_light_sensor_irq(D7);
DigitalOut seg_g(D8);
DigitalOut seg_f(D9);
DigitalOut seg_a(D10);
DigitalOut seg_b(D11);
DigitalOut seg_e(D12);
DigitalOut seg_d(D4);
DigitalOut seg_c(D14);
DigitalOut seg_dp(D15);
Ticker flipper;

char number_Pins[] = {0x7E, 0x30, 0x6D, 0x79, 0x33, 0x5B, 0x5F, 0x70, 0x7F, 0x7B};

void set_number_code(char code)
{
    seg_a = code & 0x40;
    seg_b = code & 0x20;
    seg_c = code & 0x10;
    seg_d = code & 0x8;
    seg_e = code & 0x4;
    seg_f = code & 0x2;
    seg_g = code & 0x1;
}

void set_number_dp_on()
{
    seg_dp = 1;
}

void set_number_dp_off()
{
    seg_dp = 0;
}

void flip()
{
    int adc_scale = 4096;
    int sensorValue;
    float Rsensor;
    float f_Temperature;
    char c_Temperature;
    char last_digit;
    
    f_Temperature = (adc_temp.read()*100);
    c_Temperature = (char) (f_Temperature + 0.5);
    last_digit = c_Temperature % 10;
//    printf("ADC Temp = %f | %d | %d\n", f_Temperature, c_Temperature, last_digit);
//    printf("ADC VRef = %f\n", adc_vref.read());         
//    #if defined(TARGET_DISCO_F051R8) || defined(TARGET_NUCLEO_F030R8) || defined(TARGET_NUCLEO_F031K6) || defined(TARGET_NUCLEO_F042K6) || defined(TARGET_NUCLEO_F070RB) || defined(TARGET_NUCLEO_F072RB) || defined(TARGET_NUCLEO_F091RC) || defined(TARGET_NUCLEO_F207ZG) || defined(TARGET_NUCLEO_F302R8) || defined(TARGET_NUCLEO_F303K8) || defined(TARGET_DISCO_F303VC) || defined(TARGET_NUCLEO_F303RE) || defined(TARGET_NUCLEO_F303ZE) || defined(TARGET_DISCO_F334C8) || defined(TARGET_NUCLEO_F334R8) || defined(TARGET_MTS_DRAGONFLY_F411RE) || defined(TARGET_MTS_MDOT_F405RG) || defined(TARGET_MTS_MDOT_F411RE) || defined(TARGET_DISCO_F401VC) || defined(TARGET_NUCLEO_F401RE) || defined(TARGET_ARCH_MAX) || defined(TARGET_DISCO_F407VG) || defined(TARGET_NUCLEO_F410RB) || defined(TARGET_ELMO_F411RE) || defined(TARGET_NUCLEO_F411RE) || defined(TARGET_NUCLEO_F412ZG) || defined(TARGET_DISCO_F413ZH) || defined(TARGET_DISCO_F429ZI) || defined(TARGET_NUCLEO_F429ZI) || defined(TARGET_NUCLEO_F439ZI) || defined(TARGET_B96B_F446VE) || defined(TARGET_NUCLEO_F446RE) || defined(TARGET_NUCLEO_F446ZE) || defined(TARGET_DISCO_F469NI) || defined(TARGET_DISCO_F746NG) || defined(TARGET_NUCLEO_F746ZG) || defined(TARGET_NUCLEO_F756ZG) || defined(TARGET_NUCLEO_F767ZI) || defined(TARGET_DISCO_F769NI) || defined(TARGET_DISCO_L072CZ_LRWAN1) || defined(TARGET_NUCLEO_L432KC) || defined(TARGET_DISCO_L476VG) || defined(TARGET_NUCLEO_L476RG) || defined(TARGET_NUCLEO_L486RG) 
//    printf("ADC VBat = %f\n", adc_vbat.read());
//        printf("\033[3A");
//    #else
//        printf("\033[2A");
//    #endif
    led = !led;
    set_number_code(number_Pins[last_digit]);
//    if (led){
//        set_number_code(0xFF);
//        
//    } else {
//        set_number_code(0x00);
//    }
//    if (f_Temperature > 25) {
//        wait(0.2);
//    } else {
//        wait(0.2);
//        flash_text();
//    }
    sensorValue = analog_light_sensor_read.read_u16();               
    Rsensor=(float)(adc_scale-sensorValue)*10/sensorValue;
//    printf("Light Sensor Analog Reading is 0x%X = %d   ", sensorValue, sensorValue);        
//    printf("The sensor resistance is %f  \n\n\r", Rsensor);  
/*        if (digital_light_sensor_read) {
        printf("Digital sensor is ON\r\n");  
        set_number_dp_off();
    } else {
        printf("Digital sensor is OFF\r\n");
        set_number_dp_on();
    }*/
//        digital_light_sensor_read = !digital_light_sensor_read;
    
//        printf("Digital sensor is %d \r\n", digital_light_sensor_read);  
}

int main()
{
    
    digital_light_sensor_irq.rise(&set_number_dp_off);
    digital_light_sensor_irq.fall(&set_number_dp_on);
    flipper.attach(&flip, 1.0);
    while(1) {
//        wait_ms(200); // 1s  
        sleep();
    }
}

void flash_text()
{
    float delay_ms = 0.25;

    wait(delay_ms);
    wait(delay_ms);
    
    set_number_code(0x37);
    wait(delay_ms);

    set_number_code(0x77);
    wait(delay_ms);

    set_number_code(0x37);
    wait(delay_ms);

    set_number_code(0x77);
    wait(delay_ms*4);

    set_number_code(0x0F);
    wait(delay_ms);

    set_number_code(0x06);
    wait(delay_ms);

    set_number_code(0x4E);
    wait(delay_ms);

    set_number_code(0x77);
    wait(delay_ms*4);
}

void flash_all()
{
    float delay_ms = 0.1;

    set_number_code(number_Pins[0]);
    wait(delay_ms);
    set_number_code(number_Pins[1]);
    wait(delay_ms);
    set_number_code(number_Pins[2]);
    wait(delay_ms);
    set_number_code(number_Pins[3]);
    wait(delay_ms);
    set_number_code(number_Pins[4]);
    wait(delay_ms);
    set_number_code(number_Pins[5]);
    wait(delay_ms);
    set_number_code(number_Pins[6]);
    wait(delay_ms);
    set_number_code(number_Pins[7]);
    wait(delay_ms);
    set_number_code(number_Pins[8]);
    wait(delay_ms);
    set_number_code(number_Pins[9]);
}
    
