#include "mbed.h"
#include "PinDetect.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "Letter.h"
uLCD_4DGL uLCD(p28, p27, p29); // serial tx, serial rx, reset pin;
SDFileSystem sd(p5, p6, p7, p8, "sd");

//declare objects for pins used with pushbuttons
PinDetect pb1(p18);
PinDetect pb2(p17);
PinDetect pb3(p16);

//Populate arrayCipher from cipher on SD
char arrayCipher [1001];

enum InputType {FWD,BACK,ENC,NON};
enum StateType {Q0, Q1, Q2, Q3};
Letter currLetter;
int position=0;
FILE *fp2;

InputType input = NON;
StateType state = Q0;

//Encrypt
char encrypt (char inp, char arrayCipher[], int startPt)
{
    int sum = (arrayCipher[startPt]-65) + (inp-65);
    sum = sum % 26;
    char sumC = sum;
    return sumC+65;
}

// Callback routine is interrupt activated by a debounced pb3 hit
void pb3_hit_callback (void)
{
    if (state==Q0){
        uLCD.cls();
        uLCD.printf("ENCRYPTING");
        wait(1.0);
        char inC = currLetter.getChar();
        char outC=encrypt(inC, arrayCipher, position);
        uLCD.cls();
        
        uLCD.locate(0,0);
        uLCD.text_width(5);
        uLCD.text_height(5);
        
        
        uLCD.printf("%c", outC);
        position++;
        
        //update position in txt doc
        fp2 = fopen("/sd/mydir/positionCipherSender.txt", "w");
        if(fp2 == NULL) {
            uLCD.printf("Error Open \n");
             }
        else{
            fprintf(fp2, "%i",position);
            fclose(fp2);
            }
        
        wait(1.0);
        uLCD.cls();
        input = ENC;
        }
    else{
        input=ENC;
        }
    
}
    // Callback routine is interrupt activated by a debounced pb1 hit
void pb1_hit_callback (void)
    {
        // ADD CODE HERE THAT YOU WHAT TO RUN WHEN INTERUPT IS GENERATED
        currLetter.inc();
}
        
// Callback routine is interrupt activated by a debounced pb2 hit
void pb2_hit_callback (void)
 {
         currLetter.dec();
}


int main() {
    
    FILE *fp = fopen("/sd/mydir/OTP.txt", "r");
    if(fp == NULL){
        uLCD.printf("Open Error!!!\n");
    }
    else{
        fscanf(fp, "%s", arrayCipher);
        fclose(fp);
    }
    
    FILE *fp2 = fopen("/sd/mydir/positionCipherSender.txt", "r");
    if(fp2 == NULL) {
        uLCD.printf("Open Error!!!\n");
         }
    else{
        fscanf(fp2, "%i",&position);
        fclose(fp2);
        }
    
  //  int sizeIn = sizeof(inChars)/sizeof(*inChars);


    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    
    // Delay for initial pullup to take effect
    wait(.01);
    
    // Setup Interrupt callback functions for a pb hit
    pb1.attach_deasserted(&pb1_hit_callback);
    pb2.attach_deasserted(&pb2_hit_callback);
    pb3.attach_deasserted(&pb3_hit_callback);

    // Start sampling pb inputs using interrupts
    pb1.setSampleFrequency(); //default is 20KHz sampling
    pb2.setSampleFrequency();
    pb3.setSampleFrequency();
    // pushbuttons now setup and running

while(1) {
    switch(state){
        case(Q0):
            //Produce output for this state
            uLCD.locate(0,0);
            uLCD.text_width(5);
            uLCD.text_height(5);
            uLCD.printf("%c",currLetter.getChar());
            wait(.5);
            //calculate next state
            if (input == ENC){
                state = Q1;
                input=NON;
             }
            else{ //input should be stay
                state = Q0;
            }
            break;
        
        case (Q1):
             //Produce output for this state
            
            uLCD.locate(0,0);
            uLCD.text_width(1);
            uLCD.text_height(1);
            uLCD.printf("Press Again To Encrypt More");
              //calculate next state
              if (input == ENC){
                 state = Q0;
                 input = NON;
                 uLCD.cls();
                 }
            else //input should be stay
                state = Q1;
            break;
            
        }
        //end switch
        wait (0.1);
    }
}