#include "mbed.h"
#include "Speaker.h"
#include "PinDetect.h"
#include <ctime>
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "TMP36.h"
uLCD_4DGL uLCD(p28, p27, p29); // serial tx, serial rx, reset pin;
SDFileSystem sd(p5, p6, p7, p8, "sd");

//declare objects for pins used with pushbuttons
PinDetect pb1(p18);
PinDetect pb2(p17);
PinDetect pb3(p16);

//declare a speaker object
Speaker mySpeaker(p21);

//declare enums
enum InputType {YES,NO};
enum StateType {Q0, Q1, Q2, Q3};

//declare rest of variables
InputType input = NO;
StateType state = Q0;
char cipherText [1001];
bool isWritten= false;

// Callback routine is interrupt activated by a debounced pb3 hit
void pb3_hit_callback (void)
{
    // ADD CODE HERE THAT YOU WHAT TO RUN WHEN INTERUPT IS GENERATED
    input = NO;
}
    // Callback routine is interrupt activated by a debounced pb1 hit
void pb1_hit_callback (void)
    {
        mkdir("/sd/mydir", 0777);
                FILE *fp = fopen("/sd/mydir/OTP.txt", "w");
                if(fp == NULL) {
                    uLCD.printf("Error Open \n");
                 }
         
                uLCD.cls();
                 fprintf(fp, "%s", cipherText);
                fclose(fp);
                uLCD.printf("Done;");
        input = YES;
}
        
// Callback routine is interrupt activated by a debounced pb2 hit
void pb2_hit_callback (void)
 {
         input = NO;
}

    
int main() {
    
    //instantiatenew class to set p15 to analog input
    //to read and convert TMP36 sensor's voltage output
    TMP36 myTMP36(p15);
    float tempC1, tempC2, tDiff;
    srand (time(NULL));
    int ary [1000];
    
    for(int i=0; i< 1000; i++){
        int rando=0;
        int fin=0;
        rando = rand();
        
        tempC1 = myTMP36.read();
        //wait(.1);
        tempC2 = myTMP36.read();
        tDiff = (tempC1-tempC2)*1000;
        int TRN = static_cast<int>(tDiff);
        fin = TRN + rando;
        fin = fin% 26;
        ary[i]=fin;
        }
        
    for (int i = 0; i < 1000; i++){
         int asciiVal = ary[i]+65;
        char asciiChar = asciiVal;
        cipherText[i]=asciiChar;
    }
    char z;
    z=' ';
    cipherText [1000]= z;
    
    
    //Make both positioncipher files and initialize them to 1;
    mkdir("/sd/mydir", 0777);
    FILE *fp = fopen("/sd/mydir/positionCipherSender.txt", "w");
    if(fp == NULL) {
        uLCD.printf("Error Open \n");
    }
    fprintf(fp, "%i", 0);
    fclose(fp);
    mkdir("/sd/mydir", 0777);
    fp = fopen("/sd/mydir/positionCipherReceiver.txt", "w");
    if(fp == NULL) {
        uLCD.printf("Error Open \n");
    }
    fprintf(fp, "%i", 0);
    fclose(fp);
    
    //Initialize pins
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    
    // Delay for initial pullup to take effect
    wait(.01);
    
    // Setup Interrupt callback functions for a pb hit
pb1.attach_deasserted(&pb1_hit_callback);
pb2.attach_deasserted(&pb2_hit_callback);
pb3.attach_deasserted(&pb3_hit_callback);

// Start sampling pb inputs using interrupts
pb1.setSampleFrequency(); //default is 20KHz sampling
pb2.setSampleFrequency();
pb3.setSampleFrequency();
// pushbuttons now setup and running

while(1) {
    switch(state){
        case(Q0):
            //Produce output for this state
            if(!isWritten){
                uLCD.cls();
                uLCD.printf("Save to SD?");
                isWritten=true;
            }
            //calculate next state
            if (input == YES){
                input = NO;
                state = Q1;
                isWritten=false;
                uLCD.cls();
                }
            else {
                state = Q0;
                }
            break;
        
        case (Q1):
             //Produce output for this state
             if(!isWritten){
                uLCD.cls();
                uLCD.printf("Save to another SD?");
                isWritten=true;
            }
                
              //calculate next state
              if (input == YES){
                 input = NO;
                 state = Q1;
                 isWritten=false;
                 }
            else //input should be stay
                state = Q1;
            break;
            
        }
        //end switch
        //wait (0.1);
    }
}