#include "mbed.h"
#include "TextLCD.h" // nos permite usar el lcd en nuestro comando 
#include "DebouncedIn.h" // esta libreria es útil para podeer declarar todas las teclas o botones que se posean 
TextLCD lcd(PTE0, PTE1, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7 Teclado

//asignamos el puerto a cada interruptor

DebouncedIn button1(PTC12); //Aumentar
DebouncedIn button2(PTC13); //Decrementar 
DebouncedIn button3(PTC16); //Pasar 
DebouncedIn button4(PTC17); //inicio

// asignamos los pines a la salida y a la entrada  (analógicas)

AnalogIn y(PTB1);   // Salida de la planta
AnalogOut u(PTE30); // Señal de control

//Salidas digitales utilziadas para la comprobación del funcionamiento 

DigitalOut led1(LED1); 
DigitalOut led2(LED2);
DigitalOut led3(LED3);

Timer t;// nos permite saber cuanto tiempo permanecen presionados los botones asociados al aumento y al decremento  

int C1=0x0F;  // inicializamos el lcd y el tipo de formato que este ultizará 
int sp=0,kp=0,kd=0,ki=0,p=1; // condiciones iniciales de los parametros de controlador. NOTA: la variable p indica en que se  parametro se desea intervenir (kp,ki,kd,sp, pasar e iniciar)
float  ap, ai, ad, err, med, err_v, pid=0;  // 

int main() {
    lcd.writeCommand(C1);
    lcd.printf(" Controlador PID\n");
    wait(2);
    lcd.cls();
    lcd.printf("    Equipo_5:\nEliana Mejia E.");
    wait(2);
    lcd.cls();
    lcd.printf("Sebastian Quintero Z. Sebastian Vergara P");
    wait(2);
    lcd.cls();
    lcd.printf("  Ingresar Parametros ");
    wait(2);
    
    retorno:   //Cuando se presiona por segunda vez el botón 4 se retorna a la interfaz de parametros para modificarlos
    p=1;
    lcd.cls();
    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD
    lcd.locate(8,0);
    lcd.printf("Kp=%d", kp);
    lcd.locate(0,1);
    lcd.printf("Ki=%d", ki);
    lcd.locate(8,1);
    lcd.printf("Kd=%d", kd);
    lcd.locate(0,0);
    lcd.printf("Sp=%d", sp);

    while(1) {
        if (button1.falling()) // se presiona el botón de aumento
        {
            
            led1 =!led1; // se utiliza para prender el led 
            
            // sub menú para la constante sp
            if (p==1)
            {
                
                ++sp;
                lcd.locate(3,0);
                lcd.printf("   ");
                lcd.locate(3,0);
                lcd.printf("%d", sp);
                if(sp>=5){
                    sp=5; //El límite de la señal de saida se va a encontrar entre [0V;5V]
                    lcd.locate(3,0);
                    lcd.printf("   ");
                    lcd.locate(3,0);
                    lcd.printf("%d", sp);
                }
//A continuación se explica para Kp como funciona el aumento de los parametros, para el resto de parametros
//funciona de la misma manera así que se omiten los comentarios, para el decremento tambien funciona igual
//En este caso se exhibe cuando el tiempo pasa los parametros aumentan de 10 o 100 veces, tambien se puede realizar
// con aumento unitario y más velocidad en la subida del parametro a medida que pasa el tiempo así:
/*                 
                  if((t<7) && (t>=1)){    //Primera velocidad de incremento en el intervalo 
                   
                   wait(0.3);           //Cada cierto intervalo de tiempo se cambia el wait por un valor mas pequeño 
                   ++kp;                //perceptible al ojo, de modo que aumente mas rapido unitariamente
                   lcd.locate(11,0);
                   lcd.printf("   ");
                   lcd.locate(11,0);
                   lcd.printf("%d", kp);                
                     }
*/

               
            }
            
            // sub menú para la constante kp
            else if (p==2)
            {
                ++kp; // representa un aumento unitario de la variable 
                lcd.locate(11,0);
                lcd.printf("   ");
                lcd.locate(11,0);
                lcd.printf("%d", kp);
               
              
              while(button1==0){      //se ejecuta esta instrucción, mientras el botón se encuentra presionado       
                if(t==0){t.start();}   //se contabiliza el tiempo que se deja presionado
                 
                if((t<7) && (t>=1)){    //Primera velocidad de incremento en el intervalo 
                   
                   wait(0.3);           //Espera 0.3 segundos para volver a imprimir en el lcd
                   ++kp;
                   lcd.locate(11,0);
                   lcd.printf("   ");
                   lcd.locate(11,0);
                   lcd.printf("%d", kp);                
                     }
                
                if((t>=7)&&(t<13)){    //Segunda velocidad de incremento
                  //Aumento en un factor de 10         
                   wait(0.3);          
                   kp=10+kp;               
                   lcd.locate(11,0);
                   lcd.printf("   ");
                   lcd.locate(11,0);
                   lcd.printf("%d", kp);
                    }
                if((t>=13) && (t<19)){            //Tercera velocidad de incremento 100
                   //Aumento en un factor de 100
                   wait(0.3);                     
                   kp=100+kp;                     
                   lcd.locate(11,0);
                   lcd.printf("   ");
                   lcd.locate(11,0);
                   lcd.printf("%d", kp);
                    }

                if(kp>999){      //condición limite que poseen los parámetros 
                   kp=999;
                   lcd.locate(11,0);
                   lcd.printf("    ");
                   lcd.locate(11,0);
                   lcd.printf("%d", kp);
                    }                
                    }
                    t.reset();       //Se reinicia el tiempo y vuelve a incrementar unitariamente
            }
            
            // sub menú para la constante ki
            else if (p==3)
            {
                ++ki;
                lcd.locate(3,1);
                lcd.printf("   ");
                lcd.locate(3,1);
                lcd.printf("%d", ki);
                
                             
              while(button1==0){              
                if(t==0){t.start();}   
                 
                if((t<7) && (t>=1)){     
                   wait(0.3);          
                   ++ki;
                   lcd.locate(3,1);
                   lcd.printf("   ");
                   lcd.locate(3,1);
                   lcd.printf("%d", ki);                
                     }
                
                if((t>=7)&&(t<13)){     
                   wait(0.3);         
                   ki=10+ki;
                   lcd.locate(3,1);
                   lcd.printf("   ");
                   lcd.locate(3,1);
                   lcd.printf("%d", ki);
                    }
                if((t>=13) && (t<19)){            
                  wait(0.3);        
                  ki=100+ki;
                  lcd.locate(3,1);
                  lcd.printf("   ");
                  lcd.locate(3,1);
                  lcd.printf("%d", ki);
                    }
                    
                   if(ki>999){            
                   ki=999;
                   lcd.locate(3,1);
                   lcd.printf("    ");
                   lcd.locate(3,1);
                   lcd.printf("%d", ki);
                    }  
                    
                    }
                    t.reset();       
                
            }
            
          
            // sub menú para la constante kd
            else if (p==4)
            {
                ++kd;
                lcd.locate(11,1);
                lcd.printf("   ");
                lcd.locate(11,1);
                lcd.printf("%d", kd);
                
                while(button1==0){             
                if(t==0){t.start();}   
                 
                if((t<7) && (t>=1)){    
                wait(0.3);          
                    ++kd;
                    lcd.locate(11,1);
                    lcd.printf("   ");
                    lcd.locate(11,1);
                    lcd.printf("%d", kd);                
                     }
                if((t>=7)&&(t<13)){    
                   wait(0.3);        
                    kd=10+kd;
                    lcd.locate(11,1);
                    lcd.printf("   ");
                    lcd.locate(11,1);
                    lcd.printf("%d", kd);
                    }
                
                if((t>=13) && (t<19)){    
                   wait(0.3);        
                    kd=100+kd;
                    lcd.locate(11,1);
                    lcd.printf("   ");
                    lcd.locate(11,1);
                    lcd.printf("%d", kd);
                    }
                    
                if(kd>=999){            
                          
                  kd=999;
                   lcd.locate(11,1);
                   lcd.printf("     ");
                   lcd.locate(11,1);
                   lcd.printf("%d", kd);
                   
                    }
                    }
                    t.reset();       
                
            }
        }
         // accionamiento del botón asociado al decrecimeinto de las constantes
         if (button2.falling())
        {
            led2 =!led2;
            if (p==1)
            {
                if (sp==0)  // no mostrar nada
                {
                }
                else
                {
                    --sp;
                    lcd.locate(3,0);
                    lcd.printf("   ");
                    lcd.locate(3,0);
                    lcd.printf("%d", sp);
                    
                    
                    
                }
            }
            if (p==2)
            {
                if (kp==0)  // no mostrar nada
                {
                }
                else
                {
                    --kp;
                    lcd.locate(11,0);
                    lcd.printf("   ");
                    lcd.locate(11,0);
                    lcd.printf("%d", kp);
                    
                while(button2==0){             
                if(t==0){t.start();}   
                 
                if((t<7) && (t>=1)){    
                   wait(0.3);          
                   --kp;
                   lcd.locate(11,0);
                   lcd.printf("   ");
                   lcd.locate(11,0);
                   lcd.printf("%d", kp);                
                     }
                
                if((t>=7)&&(t<13)){    
                   wait(0.3);         
                   kp=kp-10;
                   lcd.locate(11,0);
                   lcd.printf("   ");
                   lcd.locate(11,0);
                   lcd.printf("%d", kp);
                    }
                if((t>=13) && (t<19)){            
                   wait(0.3);       
                   kp=kp-100;
                   lcd.locate(11,0);
                   lcd.printf("   ");
                   lcd.locate(11,0);
                   lcd.printf("%d", kp);
                    }
                    
                    }
                    t.reset();      
                    
                }
            }
            if (p==3)
            {
                if (ki==0)  // no mostrar nada
                {
                }
                else
                {
                    --ki;
                    lcd.locate(3,1);
                    lcd.printf("   ");
                    lcd.locate(3,1);
                    lcd.printf("%d", ki);
                    
                while(button2==0){             
                if(t==0){t.start();}   
                 
                if((t<7) && (t>=1)){    
                   wait(0.3);          
                   --ki;
                    lcd.locate(3,1);
                    lcd.printf("   ");
                    lcd.locate(3,1);
                    lcd.printf("%d", ki);                
                     }
                
                if((t>=7)&&(t<13)){    
                   wait(0.3);         
                    ki=ki-10;
                    lcd.locate(3,1);
                    lcd.printf("   ");
                    lcd.locate(3,1);
                    lcd.printf("%d", ki);
                    }
                if((t>=13) && (t<19)){            
                   wait(0.3);        
                    ki=ki-100;
                    lcd.locate(3,1);
                    lcd.printf("   ");
                    lcd.locate(3,1);
                    lcd.printf("%d", ki);
                    }
                    }
                    t.reset();       
                    
                }
            }
            if (p==4)
            {
                if (kd==0)  // no se visualiza nada en el display
                {
                }
                else
                {
                    --kd;
                    lcd.locate(11,1);
                    lcd.printf("   ");
                    lcd.locate(11,1);
                    lcd.printf("%d", kd);
                    
                    while(button2==0){          
                if(t==0){t.start();}  
                 
                if((t<7) && (t>=1)){    
                   wait(0.3);          
                   --kd;
                    lcd.locate(11,1);
                    lcd.printf("   ");
                    lcd.locate(11,1);
                    lcd.printf("%d", kd);             
                     }
                
                if((t>=7)&&(t<13)){    
                   wait(0.3);        
                   kd=kd-10;
                    lcd.locate(11,1);
                    lcd.printf("   ");
                    lcd.locate(11,1);
                    lcd.printf("%d", kd);
                    }
                if((t>=13) && (t<19)){            
                   wait(0.3);        
                    kd=kd-100;
                    lcd.locate(11,1);
                    lcd.printf("   ");
                    lcd.locate(11,1);
                    lcd.printf("%d", kd);
                    }
                    }
                    t.reset();       
                    
                }
            }
        }
        // accionamiento del botón pasar
                if (button3.falling())
        {
            led3 =!led3;
            if (p==1)
            {
                ++p;
                lcd.locate(11,0);
                lcd.printf("%d", kp);
                
                
            }
            else if (p==2)
            {
                ++p;
                lcd.locate(3,1);
                lcd.printf("%d", ki);
                lcd.locate(3,1);
                
            }
            else if (p==3)
            {
                ++p;
                lcd.locate(11,1);
                lcd.printf("%d", kd);
                
                
            }
            else if (p==4)
            {
                p=1;
                lcd.locate(3,0);
                lcd.printf("%d", sp);
                
                
            }
        }
      // accionamiento del botón asociado al inicio del programa realizado
       
       if(button4.falling()){ 
        p=1;
        lcd.cls();// limpia la pantalla y la localiza en (0,0) 
        lcd.printf("Iniciando PID\n");
        wait(1); 
        while(p==1){    //si se presiona por segunda vez es para modificar los parámetros 
            if(button4.falling()){
                p=0;
                goto retorno; // se hace un llamado a la función retorno
                }
        
        med=5*y.read(); // las constantes por la cuál se amplifica la señal dependen del sistema que se desee controlar y en donde lo deseamos limitar 
        err=sp-med; // error del sistema 
        ap = kp*err; 
        
        // se verifica que la accion integral no sea muy grande
        
           if(ai<5)
           {
              ai =(ki*err)+ai; //calculo de la integral del error
           }                     
           ad = kd*(err-err_v); //calculo de la acción derivativa
           pid = (ap+ai+ad);
           
           // se verifica que pid sea positivo **************************************
           if(pid<=0){pid=0;}
           
           // se verifica que pid sea menor o igual l valor maximo *****************
          
           if(pid>=5){pid=5;}
           u.write(pid); // enviamos el valor de PID  al puerto analógico  de salida 
           t.start();  
            
            if(t>=1){
                    lcd.cls();
                    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD en este caso modulo 1
                    lcd.locate(8,0);
                    lcd.printf("Err=%0.1f", err);
                    lcd.locate(0,1);
                    lcd.printf("Med=%0.1f", med);
                    lcd.locate(8,1);
                    lcd.printf("PID=%0.1f", pid);
                    lcd.locate(0,0);
                    lcd.printf("Sp=%d", sp);
                
                t.reset();
                
                } 
            }

     
        }     
    }
    
    
}
