#include "mbed.h"
#include <Pulse1.h>
#include <string.h>
//control remoto videobeam aula
PulseInOut irda(PTD5);// en este puerto se pone el sensor infrarrojo
Serial pc(USBTX, USBRX);
PwmOut l0(PTD0);
DigitalOut l1(PTD2);
DigitalOut l2(LED2);
//PwmOut pwmLed(LED1);

int header =0;
const int head_H = 2880; //+20% medida con osciloscopio en microsegundos
const int head_L = 1920;//-20%  medida con osciloscopio
int i=0;
const int T_alto=567;//ponga su tiempo de la prueba
const int T_bajo=1170;//ponga su tiempo de la prueba
const int num_bits = 21;//ponga su numero de bits
int num[num_bits];//cadena para almacenar todos los tiempos que conforman los bits de datos
int aux[21];
int dato,prender,subir,bajar,k; // tiempo de cada dato que se lee; // tiempo de cada dato que se lee

   
int powerSONY[]=  {0,1,0,0,1,1,0,0,1,0,1,1,1,0,0,1,0,0,1,0,1}; //Boton para prender y apagar
int subirDVD[] ={1,0,0,1,1,1,1,0,1,0,1,1,1,0,0,1,0,0,1,0,1};    //Boton para aumentar el PWM
int bajarDVD[]={0,1,0,1,1,1,1,0,1,0,1,1,1,0,0,1,0,0,1,0,1};     //Boton para disminuir el PWM

int main(){
//pwmLed=0;

    while(1){

ini1: 
        fflush( stdin );
        header=0;
        //l1=1;
        header = irda.read_low_us();    //funcion para leer un pulso de caida o bajo
        if (header > head_L && header < head_H) goto seguir;//verificar que este en la tolerancia +-20%
        else goto ini1;

seguir:
        wait_us(333);
        //l1=0;
        for(i=0;i<=(num_bits-1);++i){ // POR OSCILOSCOPIO se determina que llegan (num_bits),datos
            dato = irda.read_low_us(); //leer un bit de datos que es pulso arriba en este control
            num[i]=dato;
            wait_us(333);   
        }
        
        wait(0.5); //espero un poquito antes de leer todo el arreglo y ponerlo en pantalla 
        //pc.printf(",%d",header);
        
        for(i=0;i<=(num_bits-1);++i){  
           // pc.printf(",%d",num[i]);
        }
        
        wait(0.1);  //espero  
        pc.printf("\n\n");//imprimo en binario
        for(i=0;i<=(num_bits-1);++i){  
            if(num[i] > ((T_alto+T_bajo)/2)){
                 pc.printf("1");
                 aux[i]=1;
            }
            else { 
            pc.printf("0");
            aux[i]=0;
            }
        }
               
      prender=0;
      subir=0;
      bajar=0;
 
             if(aux[0]==powerSONY[0]&&aux[1]==powerSONY[1]&&aux[2]==powerSONY[2]&&aux[3]==powerSONY[3]&&aux[4]==powerSONY[4]&&aux[5]==powerSONY[5]&&aux[6]==powerSONY[6]&&aux[7]==powerSONY[7]){
                //Se compara uno por uno de los 8 bits a comparar
                prender=21; //Se asigna un valor a la variable de prender, se llamará despues
                pc.printf("ON");//Muestra en pantalla que se prendió
             }
             if(aux[0]==subirDVD[0]&&aux[1]==subirDVD[1]&&aux[2]==subirDVD[2]&&aux[3]==subirDVD[3]&&aux[4]==subirDVD[4]&&aux[5]==subirDVD[5]&&aux[6]==subirDVD[6]&&aux[7]==subirDVD[7]){
                //Se compara uno por uno de los 8 bits a comparar
                subir=21;//Se asigna un valor a la variable de subir, se llamará despues
                pc.printf("UP");//Muestra en terminal, que esta aumentando el PWM
             }
             if(aux[0]==bajarDVD[0]&&aux[1]==bajarDVD[1]&&aux[2]==bajarDVD[2]&&aux[3]==bajarDVD[3]&&aux[4]==bajarDVD[4]&&aux[5]==bajarDVD[5]&&aux[6]==bajarDVD[6]&&aux[7]==bajarDVD[7]){
                //Se compara uno por uno de los 8 bits a comparar
                bajar=21;//Se asigna un valor a la variable de bajar, se llamará despues
                pc.printf("DOWN");//Muestra en terminal, que esta disminuyendo el PWM
             }

                
        if (l1==0 && prender==21){
            l1=1;
            l0=1;
            //Si se apreto el boton de prender y el sistema esta apagado, enciende, y visceversa
            }
        else if (l1==1 && prender==21){
            l1=0;
            l0=0;
            }
        
        if (subir==21 && l0<1){ 
            if (l0>=1) l0=1;
            l0=l0+0.15;
            //Si se apreto el boton de subir y el sistema aumenta el PWM.
        }
        
       if (bajar==21 && 0<l0){ 
            if (l0<=0) l0=0;
            l0=l0-0.15;
            //Si se apreto el boton de bajar y el sistema disminuye el PWM.
       }        
      }
}