// Sebastian Vergara-Sebastian Quintero-Eliana Mejía

// A continuación definimos las librerias necesarias para la ejecución de este programa
#include "mbed.h"
#include "Rtc_Ds1307.h"
#include "DebouncedIn.h" 
#include "QEI.h"

// Definimos las salidas digitales a usar en la freescale
DigitalOut LedVerde(LED2);
DigitalOut LedRojo(LED1);
DigitalOut LedAzul(LED3);
DigitalOut P(PTE20);

//RtcCls rtc(p28, p27, p29, true);
Rtc_Ds1307 rtc(PTE0,PTE1);
 
Serial pc(USBTX, USBRX, "pc");
 
//Aquí se configuran los puertos del encoder
QEI wheel (PTD5, PTD0, NC, 100);
 
//Se programan los botones 
DebouncedIn BotonENC(PTA16); // botón propio del encoder 
DebouncedIn Boton2(PTE21);   // boton utilizado para confirmar
 
//Salidas digitales para el uso de leds (verificar funcionamiento de alarma)
DigitalOut myled(PTE20);
DigitalOut myled2(PTE5);

//Se inicializan las variables
int dia=0,mes=0,ano=2015,hh=0,mm=0,ss=0;
char buffer[128];
int readptr = 0;
int start=0;
int Config;
 
int main() {
    char c;
    Rtc_Ds1307::Time_rtc tm = {};
    
    while(1) {
        // Se despliega el set de comandos que se usan en Movil-On para habilitar el reloj
        set_reloj:
       
        pc.printf("*************************************\n");
        pc.printf("* Menu for RTC Test :               *\n");
        pc.printf("* read  - reads the clock           *\n");
        pc.printf("* start - start the clock           *\n");
        pc.printf("* stop  - stop the clock            *\n");
        pc.printf("* write - write the clock           *\n");
        pc.printf("* ena   - enable Square wave output *\n");
        pc.printf("* dis   - disable square wave outp. *\n");
        pc.printf("*************************************\n");
        
        while( (c = pc.getc()) != '\n') {
            buffer[readptr++] = c;
        }
        buffer[readptr++] = 0;
        if (strncmp(buffer, "read", 4) == 0) {
            //  perform read
            pc.printf("Performing read operation\n");
            if (rtc.getTime(tm) ) {
                pc.printf("El tiempo actual es : %02d:%02d:%02d\n", tm.hour, tm.min, tm.sec);
                pc.printf("La fecha actual es : %s, %02d/%02d/%04d\n", rtc.weekdayToString(tm.wday), tm.mon, tm.date, tm.year);
            }
            
        }
        else if (strncmp(buffer, "write", 5) == 0) {
            // Se despliega el siguiente menú para configurar fecha y hora actual
            pc.printf("Ingrese el dia (fecha 0..31)");// Se pide ingresar un número del 0 al 31 equivalente al día del mes
            pc.scanf("%d", &tm.date);
            pc.printf("Ingrese el mes (mes 1..12)");  // se pide ingresar un valor entre 1 y 12 que representa el mes  
            pc.scanf("%d", &tm.mon);
            pc.printf("Ingrese el ano (ano)");        // a continuación se ingresa el valor del año
            pc.scanf("%d", &tm.year);
            pc.printf("Ingrese la hora (horas 0..23)");// Luego se ingresa la hora en formato 24 horas
            pc.scanf("%d", &tm.hour);
            pc.printf("Ingrese los minutos (minutos 0..59)");// Se ingresa los minutos
            pc.scanf("%d", &tm.min);
            pc.printf("Ingrese los segundos (segundos 0..59)"); //Y por último los segundos (cualquier valor, ya que es díficil su precisión)
            pc.scanf("%d", &tm.sec);
            pc.printf("Realizando la operacion... Por favor espere\n"); // Se espera la configuración de esos valores
            
            while(pc.readable()) 
                pc.getc();
            rtc.setTime(tm, false, false);
        }
        else if (strncmp(buffer, "start", 5) == 0) {
            //  start
            readptr = 0;
            pc.printf("Dispositivo Iniciado\n");
            rtc.startClock();
            goto set_prev;
            
            
        }
        else if (strncmp(buffer, "stop", 4) == 0) {
            //  stop
            pc.printf("Performing stop operation\n");
            rtc.stopClock();
        }
        else if (strncmp(buffer, "ena", 3) == 0) {
            int rs;
            pc.printf("Please specify the frequency : [0 = 1Hz, 1 = 4.096kHz, 2 = 8.192kHz, 3 = 32.768kHz] ");
            scanf("%d", &rs);
            pc.printf("Enabling the output with %d option\n", rs);
            rtc.setSquareWaveOutput(true, (Rtc_Ds1307::SqwRateSelect_t)rs);
        }
        else if (strncmp(buffer, "dis", 3) == 0) {
            pc.printf("Disableing square wave output\n");
            rtc.setSquareWaveOutput(false, Rtc_Ds1307::RS1Hz);
        }
        else {
            pc.printf("syntax error\n");
        }
        readptr = 0;
        }

        set_prev:
        pc.printf("Es correcto?  ---- 1 = Si   2 = No\n"); // se habilita esta opción para que el usuario 
        pc.scanf("%d", &Config);                           // verifique si la configuración ingresada es correcta o no
        
        if (Config ==2){                // Si se presiona 2, hubo errores en la configuración
            readptr = 0;
            goto set_reloj;             // se regresa a la función set_reloj para volver a configurar
            }
        
                  
        else if (Config ==1){           // se si presiona 1, la configuración fue correcta
             
             pc.printf("Dispositivo Configurado Correctamente  Espere ....\n"); // se espera un tiempo
             wait(5);
             goto set_alarma;           // y se va a la función correspondiente a la alarma
        }
        else {
            pc.printf("syntax error\n");
            goto set_prev;
        }

        // Aquí se encuentra la función ALARMA, en la cual se configura los valores para la activación de esta
        set_alarma:             
        pc.printf("******* Configuracion Alarma *******\n");
        
        
        set_dia:
        while(1){
         
            dia=dia+wheel.getPulses();
            wheel.reset();
     
            if(dia>=31){        //En este if, se garantiza que los días esten entre 0 y 31
                dia=31;
            }
            else if (dia<=0){
             dia=0;
            }
     pc.printf(">Dia=%d    Mes=%d    Ano=%d    Hora=%d    Min=%d    Seg=%d\n ",dia,mes,ano,hh,mm,ss);
    
    // A continuación se programan los botones del encoder para configurar con este las diferentes necesidades de la alarma
    if(BotonENC.falling()){
        goto set_mes;
        }
    if(Boton2.falling()){
        goto set_comp;
    }
           
            
    }
        
        set_mes:
        while(1){
         
            mes=mes+wheel.getPulses();
            wheel.reset();
     
            if(mes>=12){                // Se garantiza que el valor del mes se encuentre entre los valores 0 y 12
                mes=12;
            }
            else if (mes<=0){
             mes=0;
            }
     pc.printf(" Dia=%d   >Mes=%d    Ano=%d    Hora=%d    Min=%d    Seg=%d\n ",dia,mes,ano,hh,mm,ss);
    
    
    if(BotonENC.falling()){
        goto set_ano;
    }
    if(Boton2.falling()){
        goto set_comp;
    }
           
            
    }
     set_ano:
        while(1){
         
            ano=ano+wheel.getPulses();
            wheel.reset();
     
            if(ano>=2030){              //Se programan alarmas para los próximos 15 años (entre los años 2015 y 2030)
                ano=2030;
            }
            else if (ano<=2015){
             ano=2015;
            }
     pc.printf(" Dia=%d    Mes=%d   >Ano=%d    Hora=%d    Min=%d    Seg=%d\n ",dia,mes,ano,hh,mm,ss);
    
    
    if(BotonENC.falling()){
        goto set_hh;
    }
    if(Boton2.falling()){
        goto set_comp;
    }       
            
    }
    set_hh:
        while(1){
         
            hh=hh+wheel.getPulses();
            wheel.reset();
     
            if(hh>=23){         // Las horas deben encontrarse siempre en el rango de 0 a 23 (La hora 24 = La hora 0)
                hh=23;
            }
            else if (hh<=0){
             hh=0;
            }
     pc.printf(" Dia=%d    Mes=%d    Ano=%d   >Hora=%d    Min=%d    Seg=%d\n ",dia,mes,ano,hh,mm,ss);
    
    
    if(BotonENC.falling()){
        goto set_mm;
    }
    if(Boton2.falling()){
        goto set_comp;
    }
           
            
    }
     set_mm:
        while(1){
         
            mm=mm+wheel.getPulses();
            wheel.reset();
     
            if(mm>=59){         //Minutos siempre positivos entre 0 y 59 (El minuto 60 es igual al 0)
                mm=59;
            }
            else if (mm<=0){
             mm=0;
            }
     pc.printf(" Dia=%d    Mes=%d    Ano=%d    Hora=%d   >Min=%d    Seg=%d\n ",dia,mes,ano,hh,mm,ss);
    
    
    if(BotonENC.falling()){
        goto set_ss;
    }
    if(Boton2.falling()){
        goto set_comp;
    }
           
            
    }
    
    set_ss:
        while(1){
         
            ss=ss+wheel.getPulses();
            wheel.reset();
            
            if(ss>=59){         //De nuevo, en un minuto hay 60 segundos ( partiendo del 0 al 59)
                ss=59;
            }
            else if (ss<=0){
             ss=0;
            }
     pc.printf(" Dia=%d    Mes=%d    Ano=%d    Hora=%d    Min=%d   >Seg=%d\n ",dia,mes,ano,hh,mm,ss);
    
    
    if(BotonENC.falling()){
        goto set_dia;
    }
    if(Boton2.falling()){
        goto set_comp;
    }
           
            
    }
    
    // Luego de tener totalmente ingresador los datos de la alarma, se ingresa a la sección donde se compara
    // la fecha y hora actual con la fecha y hora de la alarma programada
    set_comp:
    
    pc.printf("***Datos ingresados para alarma****\n");
    pc.printf(" Dia=%d    Mes=%d    Ano=%d    Hora=%d    Min=%d    Seg=%d\n ",dia,mes,ano,hh,mm,ss);
    
    while(1){
       rtc.getTime(tm);
       pc.printf("El tiempo actual es : %02d:%02d:%02d\n", tm.hour, tm.min, tm.sec);
       pc.printf("La fecha actual es %s, %02d/%02d/%04d\n", rtc.weekdayToString(tm.wday), tm.mon, tm.date, tm.year);
    if(tm.hour>=hh && tm.min>=mm &&tm.sec>=ss && tm.mon>=mes && tm.date>=dia && tm.year>=ano){
        myled=0;        // En estas líneas de código se busca mostrar el funcionamiento de la alarma cuando 
        myled2=1;       // esta es encendida mediante el encendido y apagado alternado de dos diodos leds.
        wait(0.5);      // con un pequeño tiempo de diferencia para lograr dicho efecto.
        myled=1;
        myled2=0;
        wait(0.5);
    }
    else {
        myled=1;
        }
        wait(1);
    } 
     
    }