#include "mbed.h"
#include "floatfann.h"
#include "SDFileSystem.h"

// FRDM-K64F onboard SD card
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd");
 
int main() 
{
    
#ifdef FIXEDFANN
    printf("Using fixed fann\r\n");
#else
    printf("Using float fann\r\n");
#endif

    printf("Hello World!\n");   
    
    fann_type *calc_out;
    fann_type input[2];

    struct fann *ann = fann_create_from_file("/sd/xor_float.net");

    DigitalIn sw1(PTA4), sw2(PTC6);
    DigitalOut led(PTE26);
    
    while(1)
    {

        input[0] = sw1 * 2.0 - 1.0;
        input[1] = sw2 * 2.0 - 1.0;;
        calc_out = fann_run(ann, input);

        led = calc_out[0] > 0;
        
        printf("xor test (%f,%f) -> %f\n", input[0], input[1], calc_out[0]);
    }

    // we never reach here

    fann_destroy(ann);   
 
    printf("Goodbye World!\n");
}