/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "ESP8266.h"

#define CloudIP "184.106.153.149"

Serial pc(USBTX, USBRX);    //serial TX, RX
DigitalIn pir(D2);        //PIR motion sensor from D2 of grove base shield
AnalogIn light_sensor(A0); //light sensor from A0 of grove base shield
DigitalOut led(D7);         //lights to D7 of grove base shield
//Serial speech(PTC17, PTC16);  //UART communication with speech recognizer
ESP8266 wifi(PTC17, PTC16, 115200);         //WiFi UART
Serial HC06(PTC15, PTC14);      //Bluetooth TX, RX 

float val; 
int detect = 0;
int buf = 0;    
int count = 0;
char snd[255];
char rcv[1000]; 
int lights = 0;
char BT;

//setting up wifi
void wifi_setup()
{
    HC06.printf("WiFi Setup. Please wait...");  //indicate to app that Wifi setup is going on
    
    pc.printf("Initial Setup\r\n");
    wifi.SetMode(1);                        //Set ESP mode to 1
    wifi.RcvReply(rcv, 1000);               //Receive a response from ESP
    pc.printf("%s\r", rcv);
    
    //WiFi setup
    printf("Connecting to WiFi\r\n");    //AP Setup Initialization
    wifi.Join("Triguna_PLS", "Lakhi123$internet");//Put your Wifi SSID followed by Password WiFi_SSID WiFi_Password
    wifi.RcvReply(rcv, 1000);
    printf("%s\n", rcv);
    wait(8);
}

//send data to ThingSpeak
void sendData()
{ 
    HC06.printf("WiFi send in process. Please wait...");    //mesage BT app about send

    //Sending Data to the Cloud Server via ESP8266 WiFi Module
        strcpy(snd,"AT+CIPMUX=0+IPD\n\r");        //AT+CIPMUX: Enabling Single Channel Mode
        wifi.SendCMD(snd);
        wait(1);
        wifi.RcvReply(rcv, 1000);
        wait(1);
        printf("%s\n\r", rcv);
        
    //Establish TCP connection w/ Cloud Server
        sprintf(snd,"AT+CIPSTART=4,\"TCP\",\"%s\",80\n",CloudIP);
        wait(1);
        wifi.RcvReply(rcv, 1000);
        wait(1);
        
    //Set length of the data that will be sent
        strcpy(snd,"AT+CIPSEND=100\n\r");
        wifi.SendCMD(snd);
        printf("%s\r", rcv);
        wait(1);
        wifi.RcvReply(rcv, 1000);
        pc.printf("%s\r", rcv);
        wait(1);
        
    //Pushing the data acquired from HC-SR04 Ultrasonic Sensor to Cloud Server via API
        pc.printf("Lights\n\r");
        //GET https://api.thingspeak.com/update?api_key=0WIS9PCOJRAV3MI1&field1=0
        sprintf(snd,"\rhttps://api.thingspeak.com/update?api_key=AOIZ0D7Y2HMMHMI0&field1=%d\r", lights);
        wifi.SendCMD(snd);
        pc.printf("%s\r",snd);
        wait(0.5);
        wifi.RcvReply(rcv, 1000);
        printf("%s\r", rcv);      
        
        sprintf(snd,"AT+CIPCLOSE\n\r", lights);
        wifi.SendCMD(snd);
        
        printf("Data sent to Thingspeak!\n\r\r"); 
}  

//get data from ThingSpeak
void readData()
{
        HC06.printf("WiFi receive in process. Please wait..."); //mesage BT app about read
        
        strcpy(snd,"AT+CIPMUX=0+IPD,1\n\r");        //AT+CIPMUX: Enabling Single Channel Mode
        wifi.SendCMD(snd);
        wait(1);
        wifi.RcvReply(rcv, 1000);
        wait(1);
        
    //Establish TCP connection w/ Cloud Server
        sprintf(snd,"AT+CIPSTART=4,\"TCP\",\"%s\",80\n",CloudIP);
        wait(1);
        wifi.RcvReply(rcv, 1000);
        wait(1);
        
        strcpy(snd,"AT+CIPRECVMODE=0\n\r");
        
        //GET https://api.thingspeak.com/update?api_key=0WIS9PCOJRAV3MI1&field1=0
        sprintf(snd,"\rhttps://api.thingspeak.com/channels/1322316/fields/1/last\r");
        wifi.SendCMD(snd);
        pc.printf("%s\r",snd);
        wait(0.5);
        wifi.RcvReply(rcv, 1000);
        printf("%s\r", rcv);    
        
        sprintf(snd,"AT+CIPCLOSE\n\r", lights);
        wifi.SendCMD(snd);
        
        wifi.RcvReply(rcv, 1000);
        printf("%s\r", rcv);  
    
        printf("Data received from Thingspeak!\n\r\r"); 
}

int main() { 
    Timer time; //timer for WiFi communication
    Timer off;  //timer for lights
    
    pc.baud(115200);
    
    //welcome message
    pc.printf("Welcome to Smart Light!\n\r");
    HC06.printf("Welcome to Smart Light!\n");
    
    //wifi setup
    wifi_setup();

    //initialize lights off
    lights = 0;
    
    //start WiFi timer
    time.start();
    
    while(1) { 
        //light read
        val = light_sensor.read(); 
        printf("Light sensor reading: %2.2f - %2.2f\n\r", val, (float)(1023-val)*10/val); 
        
        //motion read
        detect = pir.read();
        if(detect == 1) {
            printf("Hello! I've detected motion\n\r");
        }
        
        //speak - the module is working but something is wrong with UART communication
        //get values but always 0 -> possibly an issue with the TX/RX of component?
        if(speech.readable()) { 
            speech.scanf("%d", &buf);
            if(buf == 1)        //1 returned when command is "Turn on the light"
                led = 1;
            else if(buf == 2)   //2 returned when command is "Turn off the light"
                led = 0;
        }
        
        
        //bluetooth read
        if(HC06.readable()) {
            BT = HC06.getc();
            if(BT == '1') {
                printf("App request on\n\r");  
                lights = 1;
            }
            else {
            printf("App request off\n\r");
            lights = 0;
         }
        }

        //lights
        //if dark and motion or bluetooth app command "on"
        if((detect == 1 && val <= 0.30) || lights == 1)
        {        
            off.start();    //start timer for lights
            led = 1;        //turn on lights
            lights = 1;     //lights on until BT app sends off
            HC06.printf("Lights on!!!\n\r");    //message user
        }
        else if (lights == 0) { //BT command to turn off
            led = 0;
            HC06.printf("Lights off!!!\n\r");
        }
    
        //timeout - cap on how long lights are on
        //turn off if on for a minute
        //1 minute so that we can see the output - real-world can be longer like after 15 minutes
        if(off.read_ms() >= 60000 && led == 1) {
            led = 0;
            lights = 0;
            printf("\n\rTimeout - turning lights off\n\r");
            HC06.printf("Timeout - turning lights off");    //message to serial and BT
            off.reset();    //reset timer
        }
             
        //interact with ThingSpeak every minute
        //again, 1 minute so that we can see the output - real-world can be longer like every 15 minutes
        if(time.read_ms() >= 60000) {
            printf("\n\rTimer reached %d ms: ThingSpeak interaction:\n\r", time.read_ms());
            
            HC06.printf("WiFi exchange in process. Please wait...");    //message to app
            
            //sendData
            sendData();
            
            //readData
            readData();
            
            //reset timer
            time.reset();   
            
            HC06.printf("WiFi done! Ready to receive"); //indicate to app that ready to receive
        }

        //pause before next read - remove for better timing
        //in place so as not to crowd the serial monitor
        wait(1);

    } 
     
}
