#include "mbed.h"
#include "Servo.h"
#include "hcsr04.h"
#include "Thread.h"

//pin connections
Serial pc(USBTX, USBRX);
Servo myservo(PTA1);
AnalogIn force(A0);
HCSR04 usensor(D8,D9);                     //ECHO Pin=D9, TRIG Pin=D8
DigitalOut red(LED1);
Serial HC06(PTC15, PTC14); //BT TX, RX

Thread t1;
Thread t2;
Thread t3;

Mutex open; //mutex for door

//force sensor thread
void force_open() {
    float weight;
    int door = 0;
    
    while(1) {  
        //read analog pin
        weight = force.read();
        printf("force = %f\r\n", weight * 1000);
    
        //if object detected or user asks for serving and door closed, then open
        if((weight*1000) >= 200 && door == 0) { 
            open.lock();    //lock
            
            myservo.write(0.0);
            door = 1;
    
            wait(0.25);
            //if open for .25 seconds, close - portion control
            myservo.write(0.75);
            
            open.unlock();  //unlock
            door = 0;
        }
        
        wait(5); //look for bowl every 5 seconds 
    }
}

//bluetooth control thread
void bt_open() {
    
    char bt;
    int door = 0;
    
    while(1) {
        
        //data from BT
        if(HC06.readable())
        {
            //read
            bt = HC06.getc();
            printf("BT=%c\n\r", bt);
            //open
            if(bt == '3' && door == 0) {
                open.lock();    //lock
                
                myservo.write(0.0);
                door = 1;
                printf("BT START\n\r");
            }
            //close - no timer!
            else if(bt == '4' && door == 1) {
                myservo.write(0.75); 
                door = 0;
                open.unlock(); //unlock
                
                printf("BT STOP\n\r");
            }   
        }
    }
}

//ultrasonic thread
void empty_detect() {
    int dist;
    int count = 0;
    
    while(1) {
        usensor.start();
    
        wait_ms(500);
        dist = usensor.get_dist_cm();   //read
        printf("distance = %d\n\r", dist);
        
        //food is there
        if(dist > 0 && dist < 28) {
            red = 1;
            HC06.printf("0");
        }
        else {  //empty
            red = 0;    //turn on red light
            
            if(count % 10 == 0)
            {
                //bluetooth message
                HC06.printf("1");
                printf("----------------------------------------------\n\r");
                printf("Notifying user that refill is needed\n\r");
                printf("----------------------------------------------\n\r");
            }
            count++;    //for frequent notification
        }
    }
}

int main()
{
    printf("Welcome to Cereal Dispenser\n\r");
    usensor.start();
    
    red = 1;    //LED off
    
    while(1) {
    
        //start threads
        t1.start(force_open);
        t2.start(bt_open);
        t3.start(empty_detect);
    }
}