#include "mbed.h"
#include "m3pi_ng.h"
 
m3pi pi;
 
int main() {
 
    // Parameters that affect the performance
    float speed = 0.7; //geschw.
    float correction = 0.5;   //korrektur links, rechts
    float threshold = 0.5;  //schwelle, korrektur
 
    pi.locate(0,1); //vorgefertigte position, ausrichten
    pi.printf("Runde: ");
 
    wait(2.0);
    
    pi.sensor_auto_calibrate();
    
    while (1) {
 
        // -1.0 is far left, 1.0 is far right, 0.0 in the middle
        float position_of_line = pi.line_position();
 
        // Line is more than the threshold to the right, slow the left motor
        if (position_of_line > threshold) {
            pi.leftt_motor(speed);
            pi.right_motor(speed-correction);
        }
 
        // Line is more than 50% to the left, slow the right motor
        else if (position_of_line < -threshold) {
            pi.right_motor(speed);
            pi.left_motor(speed-correction);
        }
 
        // Line is in the middle
        else {
            pi.forward(speed);
        }
    }
}