#include "mbed.h"
#include "uLCD_4DGL.h"
#include <stdlib.h>
#include "rhythm.h"
#include "SDFileSystem.h"
#include "wave_player.h"

Rhythm::Rhythm() 
{
sd = new SDFileSystem(p5, p6, p7, p8, "sd");
DACout = new AnalogOut(p18);
waver = new wave_player(DACout);
uLCD = new uLCD_4DGL(p13,p14,p12);
Up = new DigitalIn(p24);
Left = new DigitalIn(p26);
Right = new DigitalIn(p28);
Center = new DigitalIn(p25);
Down = new DigitalIn(p27);
up = false;
down = false;
left = false;
right = false;
center = false;
score = 0;
endloop = 0; 
random_number = 0;
shape_color = 0;
average_reaction_time = 0;
}

void Rhythm::drawBorder() {
    //Left side 1
    uLCD->line(0, 0, 10, 16, RED);
    uLCD->line(10, 16, 0, 32, GREEN);
    uLCD->line(0, 32, 10, 48, BLUE);
    uLCD->line(10, 48, 0, 64, RED);
    uLCD->line(0, 64, 10, 80, GREEN);
    uLCD->line(10, 80, 0, 96, BLUE);
    uLCD->line(0, 96, 10, 112, RED);
    uLCD->line(10, 112, 0, 128, GREEN);
    //Left side 2
    uLCD->line(10, 0, 0, 16, GREEN);
    uLCD->line(0, 16, 10, 32, BLUE);
    uLCD->line(10, 32, 0, 48, RED);
    uLCD->line(0, 48, 10, 64, GREEN);
    uLCD->line(10, 64, 0, 80, BLUE);
    uLCD->line(0, 80, 10, 96, RED);
    uLCD->line(10, 96, 0, 112, GREEN);
    uLCD->line(0, 112, 10, 128, BLUE);
    //Bottom 1
    uLCD->line(0, 128, 16, 118, BLUE);
    uLCD->line(16, 118, 32, 128, RED);
    uLCD->line(32, 128, 48, 118, GREEN);
    uLCD->line(48, 118, 64, 128, BLUE);
    uLCD->line(64, 128, 80, 118, RED);
    uLCD->line(80, 118, 96, 128, GREEN);
    uLCD->line(96, 128, 112, 118, BLUE);
    uLCD->line(112, 118, 128, 128, RED);
    //Bottom 2
    uLCD->line(0, 118, 16, 128, RED);
    uLCD->line(16, 128, 32, 118, GREEN);
    uLCD->line(32, 118, 48, 128, BLUE);
    uLCD->line(48, 128, 64, 118, RED);
    uLCD->line(64, 118, 80, 128, GREEN);
    uLCD->line(80, 128, 96, 118, BLUE);
    uLCD->line(96, 118, 112, 128, RED);
    uLCD->line(112, 128, 128, 118, GREEN);
    //Right side 1
    uLCD->line(128, 128, 118, 112, GREEN);
    uLCD->line(118, 112, 128, 96, BLUE);
    uLCD->line(128, 96, 118, 80, RED);
    uLCD->line(118, 80, 128, 64, GREEN);
    uLCD->line(128, 64, 118, 48, BLUE);
    uLCD->line(118, 48, 128, 32, RED);
    uLCD->line(128, 32, 118, 16, GREEN);
    uLCD->line(118, 16, 128, 0, BLUE);
    //Right side 2
    uLCD->line(118, 128, 128, 112, BLUE);
    uLCD->line(128, 112, 118, 96, RED);
    uLCD->line(118, 96, 128, 80, GREEN);
    uLCD->line(128, 80, 118, 64, BLUE);
    uLCD->line(118, 64, 128, 48, RED);
    uLCD->line(128, 48, 118, 32, GREEN);
    uLCD->line(118, 32, 128, 16, BLUE);
    uLCD->line(128, 16, 118, 0, RED);
    //Top 1
    uLCD->line(128, 0, 112, 10, RED);
    uLCD->line(112, 10, 96, 0, GREEN);
    uLCD->line(96, 0, 80, 10, BLUE);
    uLCD->line(80, 10, 64, 0, RED);
    uLCD->line(64, 0, 48, 10, GREEN);
    uLCD->line(48, 10, 32, 0, BLUE);
    uLCD->line(32, 0, 16, 10, RED);
    uLCD->line(16, 10, 0, 0, GREEN);
    //Top 2
    uLCD->line(128, 10, 112, 0, GREEN);
    uLCD->line(112, 0, 96, 10, BLUE);
    uLCD->line(96, 10, 80, 0, RED);
    uLCD->line(80, 0, 64, 10, GREEN);
    uLCD->line(64, 10, 48, 0, BLUE);
    uLCD->line(48, 0, 32, 10, RED);
    uLCD->line(32, 10, 16, 0, GREEN);
    uLCD->line(16, 0, 0, 10, BLUE);
}

void Rhythm::drawLevel1Screen() {
    uLCD->cls();
    drawBorder();
    uLCD->text_string("Level 1", 6, 6, FONT_7X8, BLUE);
}

void Rhythm::drawLevel2Screen() {
    uLCD->cls();
    drawBorder();
    uLCD->text_string("Level 2", 6, 6, FONT_7X8, GREEN);
}    

void Rhythm::drawLevel3Screen() {
    uLCD->cls();
    drawBorder();
    uLCD->text_string("Level 3", 6, 6, FONT_7X8, RED);
}

void Rhythm::drawEndScreen() {
    uLCD->cls();
    drawBorder();
    uLCD->text_string("Thank You", 5, 7, FONT_7X8, 0xFFFF00);
    uLCD->text_string("For Playing", 4, 9, FONT_7X8, 0xFFFF00);
    for (int i = 0; i < 3; i++) {
        playMusicEnd();
    }
}

void Rhythm::generateRandomColor() {
    random_number = rand() % 6;
    if (random_number == 0) {
        shape_color = 0xFF0000;
    } else if (random_number == 1) {
        shape_color = 0x00FF00;
    } else if (random_number == 2) {
        shape_color = 0x0000FF;
    } else if (random_number == 3) {
        shape_color = 0xFFFF00;
    } else if (random_number == 4) {
        shape_color = 0x00FFFF;
    } else if (random_number == 5) {
        shape_color = 0xFF00FF;
    }
}

void Rhythm::drawUpArrow() {
    uLCD->cls();
    generateRandomColor();
    uLCD->filled_rectangle(60, 52, 68, 76, shape_color); 
    for (int n = 0; n < 9; n++) {
        uLCD->line(56 + n, 52 - n, 72 - n, 52 - n, shape_color);
    }
    up = true;
    down = false;
    left = false;
    right = false;
    center = false;
}

void Rhythm::drawDownArrow() {
    uLCD->cls();
    generateRandomColor();
    uLCD->filled_rectangle(60, 52, 68, 76, shape_color); 
    for (int n = 0; n < 9; n++) {
        uLCD->line(56 + n, 76 + n, 72 - n, 76 + n, shape_color);
    }
    up = false;
    down = true;
    left = false;
    right = false;
    center = false;
}

void Rhythm::drawLeftArrow() {
    uLCD->cls();
    generateRandomColor();
    uLCD->filled_rectangle(52, 60, 76, 68, shape_color); 
    for (int n = 0; n < 9; n++) {
        uLCD->line(52 - n, 56 + n, 52 - n, 72 - n, shape_color);
    }
    up = false;
    down = false;
    left = true;
    right = false;
    center = false;
    
}

void Rhythm::drawRightArrow() {
    uLCD->cls();
    generateRandomColor();
    uLCD->filled_rectangle(52, 60, 76, 68, shape_color); 
    for (int n = 0; n < 9; n++) {
        uLCD->line(76 + n, 56 + n, 76 + n, 72 - n, shape_color);
    }
    up = false;
    down = false;
    left = false;
    right = true;
    center = false;
    
}

void Rhythm::drawCenterCircle() {
    uLCD->cls();
    generateRandomColor();
    uLCD->filled_circle(64, 64, 15, shape_color); 
    up = false;
    down = false;
    left = false;
    right = false;
    center = true;
    
}

void Rhythm::getArrowDirection()
{
int randgen = rand() % 5;   
if(randgen == 0)
{
drawUpArrow();
}
else if(randgen == 1)
{
drawDownArrow(); 
}
else if(randgen == 2)
{
drawLeftArrow();
}
else if(randgen == 3)
{
drawRightArrow();
}
else if(randgen == 4)
{
drawCenterCircle();  
}
t.start();
endloop++;
}


void Rhythm::level1()
{
drawLevel1Screen();
wait(2.0);
getArrowDirection();
while(endloop <= 10)
{
if(up && Up->read() == 0 && t.read() <= 3.0)
{
reaction_times[endloop - 1] = t.read();
score++;
t.stop();
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if(down && Down->read() == 0 && t.read() <= 3.0)
{
reaction_times[endloop - 1] = t.read();
score++;
t.stop();
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if(left && Left->read() == 0 && t.read() <= 3.0)
{
reaction_times[endloop - 1] = t.read();
score++;
t.stop();
t.reset();
wait(0.3);
if (endloop == 10) {break;}  
getArrowDirection();
}
else if(right && Right->read() == 0 && t.read() <= 3.0)
{
reaction_times[endloop - 1] = t.read();
score++;
t.stop();
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if(center && Center->read() == 0 && t.read() <= 3.0)
{
reaction_times[endloop - 1] = t.read();
score++;
t.stop();
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if (up && (Down->read() == 0 || Left->read() == 0 || Right->read() == 0 || Center->read() == 0)&& t.read() < 3.0)
{
reaction_times[endloop - 1] = t.read();
t.stop();    
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if (down && (Up->read() == 0 || Left->read() == 0 || Right->read() == 0 || Center->read() == 0)&& t.read() < 3.0)
{
reaction_times[endloop - 1] = t.read();
t.stop();    
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if (left && (Down->read() == 0 || Up->read() == 0 || Right->read() == 0 || Center->read() == 0)&& t.read() < 3.0)
{
reaction_times[endloop - 1] = t.read();
t.stop();    
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if (right && (Down->read() == 0 || Left->read() == 0 || Up->read() == 0 || Center->read() == 0)&& t.read() < 3.0)
{
reaction_times[endloop - 1] = t.read();
t.stop();    
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if (center && (Down->read() == 0 || Left->read() == 0 || Right->read() == 0 || Up->read() == 0) && t.read() < 3.0)
{
reaction_times[endloop - 1] = t.read();
t.stop();    
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if( t.read() >= 3.0)
{
reaction_times[endloop - 1] = t.read();
t.stop();
t.reset();
if (endloop == 10) {break;}
getArrowDirection();
}
}
endloop = 0;
computeAverageReactionTime();
drawResultsScreen();
}

void Rhythm::level2()
{
drawLevel2Screen();
wait(2.0);
getArrowDirection();
while(endloop <= 10)
{
if(up && Up->read() == 0 && t.read() <= 2.0)
{
reaction_times[endloop - 1] = t.read();
score++;
t.stop();
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if(down && Down->read() == 0 && t.read() <= 2.0)
{
reaction_times[endloop - 1] = t.read();
score++;
t.stop();
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if(left && Left->read() == 0 && t.read() <= 2.0)
{
reaction_times[endloop - 1] = t.read();
score++;
t.stop();
t.reset();
wait(0.3);  
if (endloop == 10) {break;}
getArrowDirection();
}
else if(right && Right->read() == 0 && t.read() <= 2.0)
{
reaction_times[endloop - 1] = t.read();
score++;
t.stop();
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if(center && Center->read() == 0 && t.read() <= 2.0)
{
reaction_times[endloop - 1] = t.read();
score++;
t.stop();
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if (up && (Down->read() == 0 || Left->read() == 0 || Right->read() == 0 || Center->read() == 0)&& t.read() < 2.0)
{
reaction_times[endloop - 1] = t.read();
t.stop();    
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if (down && (Up->read() == 0 || Left->read() == 0 || Right->read() == 0 || Center->read() == 0)&& t.read() < 2.0)
{
reaction_times[endloop - 1] = t.read();
t.stop();    
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if (left && (Down->read() == 0 || Up->read() == 0 || Right->read() == 0 || Center->read() == 0)&& t.read() < 2.0)
{
reaction_times[endloop - 1] = t.read();
t.stop();    
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if (right && (Down->read() == 0 || Left->read() == 0 || Up->read() == 0 || Center->read() == 0)&& t.read() < 2.0)
{
reaction_times[endloop - 1] = t.read();
t.stop();    
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if (center && (Down->read() == 0 || Left->read() == 0 || Right->read() == 0 || Up->read() == 0) && t.read() < 2.0)
{
reaction_times[endloop - 1] = t.read();
t.stop();    
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if( t.read() >= 2.0)
{
reaction_times[endloop - 1] = t.read();
t.stop();
t.reset();
if (endloop == 10) {break;}
getArrowDirection();
}
}
endloop = 0;
computeAverageReactionTime();
drawResultsScreen();
}

void Rhythm::level3()
{
drawLevel3Screen();
wait(2.0);
getArrowDirection();
while(endloop <= 10)
{
if(up && Up->read() == 0 && t.read() <= 1.0)
{
reaction_times[endloop - 1] = t.read();
score++;
t.stop();
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if(down && Down->read() == 0 && t.read() <= 1.0)
{
reaction_times[endloop - 1] = t.read();
score++;
t.stop();
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if(left && Left->read() == 0 && t.read() <= 1.0)
{
reaction_times[endloop - 1] = t.read();
score++;
t.stop();
t.reset();
wait(0.3);  
if (endloop == 10) {break;}
getArrowDirection();
}
else if(right && Right->read() == 0 && t.read() <= 1.0)
{
reaction_times[endloop - 1] = t.read();
score++;
t.stop();
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if(center && Center->read() == 0 && t.read() <= 1.0)
{
reaction_times[endloop - 1] = t.read();
score++;
t.stop();
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if (up && (Down->read() == 0 || Left->read() == 0 || Right->read() == 0 || Center->read() == 0)&& t.read() < 1.0)
{
reaction_times[endloop - 1] = t.read();
t.stop();    
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if (down && (Up->read() == 0 || Left->read() == 0 || Right->read() == 0 || Center->read() == 0)&& t.read() < 1.0)
{
reaction_times[endloop - 1] = t.read();
t.stop();    
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if (left && (Down->read() == 0 || Up->read() == 0 || Right->read() == 0 || Center->read() == 0)&& t.read() < 1.0)
{
reaction_times[endloop - 1] = t.read();
t.stop();    
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if (right && (Down->read() == 0 || Left->read() == 0 || Up->read() == 0 || Center->read() == 0)&& t.read() < 1.0)
{
reaction_times[endloop - 1] = t.read();
t.stop();    
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if (center && (Down->read() == 0 || Left->read() == 0 || Right->read() == 0 || Up->read() == 0) && t.read() < 1.0)
{
reaction_times[endloop - 1] = t.read();
t.stop();    
t.reset();
wait(0.3);
if (endloop == 10) {break;}
getArrowDirection();
}
else if( t.read() >= 1.0)
{
reaction_times[endloop - 1] = t.read();
t.stop();
t.reset();
if (endloop == 10) {break;}
getArrowDirection();
}
}
endloop = 0;
computeAverageReactionTime();
drawResultsScreen();
}

void Rhythm::drawTitleScreen() {
uLCD->cls();
uLCD->background_color(BLACK);
uLCD->text_bold(ON);
uLCD->text_string("MBED Rhythm", 2, 4, FONT_7X8, WHITE);
uLCD->text_string("Down - Level 1", 2, 6, FONT_7X8, BLUE);
uLCD->text_string("Up - Level 2", 2, 8, FONT_7X8, GREEN);
uLCD->text_string("Right - Level 3", 2, 10, FONT_7X8, RED);
playMusicIntro();
while(1)
{
if (Down->read() == 0) {
    level1();
    break;
} else if (Up->read() == 0) {
    level2();
    break;
} else if (Right->read() == 0) {
    level3();
    break;
}
}
}

void Rhythm::computeAverageReactionTime() {
    float sum = 0;
    for (int i = 0; i < 10; i++) {
        sum = sum + reaction_times[i];
    }
    average_reaction_time = sum / 10.0;
}

void Rhythm::drawResultsScreen() {
    uLCD->cls();
    uLCD->text_string("Results", 1, 1, FONT_7X8, WHITE);
    uLCD->set_font(FONT_7X8);
    uLCD->locate(1, 3);
    uLCD->color(GREEN);
    uLCD->printf("Score: %d", score);
    uLCD->locate(1, 5);
    uLCD->color(0xFFCA00);
    uLCD->printf("Average Reaction  Time: %1.3f sec", average_reaction_time);
    uLCD->locate(1, 8);
    uLCD->color(0xFF00FF);
    uLCD->printf("Would you like to play again?");
    uLCD->locate(1, 11);
    uLCD->color(BLUE);
    uLCD->printf("Up - Yes");
    uLCD->locate(1, 13);
    uLCD->color(RED);
    uLCD->printf("Down - No");
    score = 0;
    for (int i = 0; i < 10; i++) {
        reaction_times[i] = 0;
    }
    average_reaction_time = 0;
    playMusicResults();
    while (1) {
    if (Up->read() == 0) {
        drawTitleScreen();
    } else if (Down->read() == 0) {
        drawEndScreen();
    }
    }
}

void Rhythm::playMusicIntro()
{
FILE *wave_file;
wave_file = fopen("/sd/wavfiles/WW_PressStart.wav","r");
waver->play(wave_file);
fclose(wave_file);
}

void Rhythm::playMusicEnd()
{
FILE *wave_file;
wave_file = fopen("/sd/wavfiles/WW_Get_Rupee_Red.wav","r");
waver->play(wave_file);
fclose(wave_file);
}

void Rhythm::playMusicResults()
{
FILE *wave_file;
wave_file = fopen("/sd/wavfiles/WW_ChuChu_Wobble.wav","r");
waver->play(wave_file);
fclose(wave_file);
}