#include "mbed.h"
#include "uLCD_4DGL.h"
#include <stdlib.h>
#include "SDFileSystem.h"
#include "wave_player.h"

class Rhythm { 
private:
SDFileSystem* sd;
AnalogOut* DACout;
wave_player* waver;
uLCD_4DGL* uLCD;
DigitalIn* Up;
DigitalIn* Left;
DigitalIn* Right;
DigitalIn* Center;
DigitalIn* Down;
Timer t;
bool up;
bool down;
bool left;
bool right;
bool center;
int score;
int endloop; 
int random_number;
int shape_color;
float reaction_times[10];
float average_reaction_time;

public:
Rhythm();
void drawBorder();
void generateRandomColor();
void drawLevel1Screen() ;
void drawLevel2Screen();
void drawLevel3Screen();
void drawEndScreen();
void drawUpArrow();
void drawDownArrow();
void drawLeftArrow();
void drawRightArrow();
void drawCenterCircle();
void getArrowDirection();
void level1();
void level2();
void level3();
void drawTitleScreen();
void computeAverageReactionTime();
void drawResultsScreen();
void playMusicIntro();
void playMusicEnd();
void playMusicResults();
};






