/*
 * motor_lockedantiphase.h
 *
 *  Created on: 2014/04/23
 *      Author: spiralray
 */

#ifndef MOTOR_LOCKEDANTIPHASE_H_
#define MOTOR_LOCKEDANTIPHASE_H_

#include "mbed.h"

class Motor_LockedAntiphase
{
public:

  Motor_LockedAntiphase(PwmOut ma, PwmOut mb);
  ~Motor_LockedAntiphase();

  /** Set the PWM period, specified in seconds (float), keeping the duty cycle the same.
   *
   *  @note
   *   The resolution is currently in microseconds; periods smaller than this
   *   will be set to zero.
   */
  void period(float seconds) {
    motora.period(seconds);
    motorb.period(seconds);
  }

  /** Set the PWM period, specified in milli-seconds (int), keeping the duty cycle the same.
   */
  void period_ms(int ms) {
    motora.period_ms(ms);
    motorb.period_ms(ms);
  }

  /** Set the PWM period, specified in micro-seconds (int), keeping the duty cycle the same.
   */
  void period_us(int us) {
    motora.period_us(us);
    motorb.period_us(us);
  }

#ifdef MBED_OPERATORS
  /** A operator shorthand for write()
   */
  Motor_LockedAntiphase& operator= (float value) {
    motora.write(0.5f+value/2);
    motorb.write(0.5f-value/2);
    return *this;
  }
#endif

private:
  PwmOut motora,motorb;

};

#endif /* MOTOR_LOCKEDANTIPHASE_H_ */
