/*
Shamelessly stole the samples from a Qbasic speech engine...

'BASIC speech engine 2.0 by Steven M
'StevenM86aol.com
'http://members.aol.com/StevenM86/
'                                       

*/

#include "Pokitto.h"
#include "HWSound.h"
#include "speak.h"
#include "music.h"

Pokitto::Core mygame;
Pokitto::Display d;


typedef struct{
    bool playSample;
    int soundPoint;
    const uint8_t *currentSound;
    int currentSoundSize;
    int volume;
    int speed;
} sampletype;

sampletype snd[10]; // up to 10 sounds at once?
int oldQuart;

Ticker sounder;
char myWord[] = "testing Wan tu HrE for fIv           ";


void emptyBuffer(){
    for(int t=0; t<SBUFSIZE;){
        soundbuf[++t]=0;
    }

    for(int t=0; t<10; t++){
        snd[t].playSample=0;
    }

}

uint8_t playSound(const unsigned char *sound, uint32_t soundSize, int volume = 255, float speed=255){

    int channel = 0;
    float spd = (POK_AUD_FREQ / 11025);

    snd[channel].currentSound = sound;                      // sound to play
    snd[channel].currentSoundSize = (soundSize<<8)/speed;   // length of sound array adjusted for speed change
    snd[channel].volume = volume;                            // volume, best kept below 64 as louder will cause clipping when playing multiple samples
    snd[channel].speed = (speed/spd);                             // recalculated above
    snd[channel].soundPoint = 0;                            // where the current sound is upto
    snd[channel].playSample = 1;                            // 1 to play this sound, 0 not to

    return channel;
}

uint8_t mixSound(int samplePos)
{
    int temp = 0;
    int t=0;
        if(snd[t].playSample!=0){
            int currentSample = (snd[t].currentSound[(snd[t].soundPoint*snd[t].speed)>>8]);
            temp = currentSample;
        }
    return temp;
}


void updateSample(){

 int quart = soundbufindex / 512;
 int sndOffset[]={512,1024,1536,0};

    if(oldQuart != quart){
        oldQuart = quart;
        for(int t=0; t<=SBUFSIZE/4;){
            soundbuf[t+sndOffset[quart]] = 127;
            uint8_t sample = mixSound(t);
            int s=0;
            if(snd[s].playSample!=0){
                soundbuf[t+sndOffset[quart]] = sample;
            }
            //for(int s=0; s<10; s++){
                ++snd[s].soundPoint;
                if(snd[s].soundPoint >= snd[s].currentSoundSize){
                    snd[s].playSample=0;
                }
            //}
            t++;
        }
    }
}



int main ()
{
    mygame.begin();
    pokPlayStream();
    emptyBuffer(); // clear the sound buffer

    sounder.attach(&updateSample, 0.0001);

//    playSound(rawData, sizeof(rawData));

    int letter=0;
    while (mygame.isRunning())
    {
        if (mygame.update())
        {
            // update buttons

            if(snd[0].playSample == 0){
                int toPlay = myWord[letter];
                
                if(toPlay < 97 || toPlay > 97+25){
                    toPlay='0';
                }
                
                if(toPlay>=97 && toPlay <=122){
                    int start = sndPos[toPlay-97];
                    int size = sndSize[toPlay-97];
                    playSound(&ABC[start], size);
                }

                if(toPlay>=65 && toPlay <=90){
                    int start = sndPos[toPlay-65+26];
                    int size = sndSize[toPlay-65+26];
                    playSound(&ABC[start], size);
                }

                if(toPlay>=48 && toPlay <=57){
                    int start = sndPos[toPlay-48+52];
                    int size = sndSize[toPlay-48+52];
                    playSound(&ABC[start], size);
                }

                if(++letter==sizeof(myWord))letter=0;
            }

                        

        }
    }
}


/*

The sound codes are:
A  as in bAnanA:    a
A  as in mAp:       A
A  as in bOther:    1
Ay as in dAY:       2
A  as in bAd:       3
Aw as in nOW:       4
Aw as in sAW:       5
B  as in BaBy:      b
Ch as in CHin:      c
D  as in unDone:    d
E  as in bEt:       e
Ea as in bEAt:      E
F  as in FiFty:     f
G  as in Go:        g
G  as in Gem:       G
H  as in Hat:       h
I  as in tIp:       i
I  as in bUY:       I
Ir as in bIRd:      j
K  as in CooK:      k
L  as in pooL:      l
M  as in diM:       m
N  as in No:        n
Ng as in siNG:      N
O  as in bOne:      o
Oi as in cOIn:      O
O  as in jOb:       6
Oo as in wOOd:      7
P  as in PePPer:    p
R  as in RaRe:      r
S  as in leSS:      s
Sh as in SHy:       S
T  as in aTTack:    t
Th as in THen:      T
Th as in THirteen:  H
U  as in rUle:      u
U  as in hUmdrUm:   U
U  as in Union:     8
U  as in cUrable:   9
V  as in giVe:      v
W  as in We:        w
W  as in ONe:       W
Z  as in raISE:     z
Pause (about 25ms): 0

*/