#include "Pokitto.h"
#include "gfx.h"

#define ADDRESS 0xA4 // 0x52 << 1

Pokitto::Core game;
I2C i2c(P0_5, P0_4);    // sda, scl


unsigned char dataFormat;
unsigned char controllerType[6];
bool connected, old_connected;
uint8_t _data[21];
int w_LX, w_RX, w_LY, w_RY, w_LT, w_RT, w_AX, w_AY, w_AZ;
bool w_RIGHT, w_DOWN, w_L, w_MINUS, w_HOME, w_PLUS, w_R, w_LZ, w_B, w_Y, w_A, w_X, w_RZ, w_LEFT, w_UP;
int wiiError,oldError;
int controlType=-1;

unsigned char conTypes[3][6]={
    {0x00,0x00,0xA4,0x20,0x00,0x00}, // 0 = Nunchuck
    {0x00,0x00,0xA4,0x20,0x01,0x01}, // 1 = Classic controller
    {0x01,0x00,0xA4,0x20,0x01,0x01}, // 2 = Classic controller pro
};
char *controller[3] = {"Nunchuck","Classic controller","Classic controller pro"};
void init_classic();




void checkController(){
    //game.display.clear();
    char tempText[20];
    game.display.setCursor(0,77);
    controlType=-1;
    for(char s=0; s<3; s++){
        unsigned char tempCount=0;
            for(char t=0; t<6; t++){
                // check controller against known models. 5th byte ignored, as it is changed by init process
                if(t!=4){ if(controllerType[t] == conTypes[s][t]){ tempCount++; } }
            }
        if(tempCount==5){controlType=s;}
    }
    //Serial.print("Controller:");
    if(controlType<0){
        game.display.print("Not Connected");
        //  Serial.println("Not Connected");
    }else{
        //  Serial.println(controller[controlType]);
        sprintf(tempText,"%s\n",controller[controlType]);
        game.display.print(tempText);
    }

        sprintf(tempText,"DataFormat = %d\n",dataFormat);
        game.display.print(tempText);

}

void updateClassic()
{
            i2c.write(ADDRESS, (const char*)0x00, 1);
            // wait
            wait_ms(10);
            if(i2c.read(ADDRESS, (char*)_data, 8)){
                connected = 0;
            }else{
                connected = 1;

                if(controlType == 0){
                    // nunchuck
                    // nunchuck only does format 1
                    w_LX = _data[0];
                    w_LY = _data[1];
                    w_AX = (_data[2] << 2) | ((_data[5] >> 2) & 3);
                    w_AY = (_data[3] << 2) | ((_data[5] >> 4) & 3);
                    w_AZ = (_data[4] << 2) | ((_data[5] >> 6) & 3);
                    w_LZ = !((_data[5] >> 0) & 1);
                    w_L = !((_data[5] >> 1) & 1);
                }
                if(controlType == 1 || controlType == 2){
                    // classic controller or classic controller pro
                    w_LX = _data[0];
                    w_RX = _data[1];
                    w_LY = _data[2];
                    w_RY = _data[3];
                    w_LT = _data[4];
                    w_RT = _data[5];
                    w_RIGHT = _data[6]&B10000000 ? 0:1;
                     w_DOWN = _data[6]&B01000000 ? 0:1;
                        w_L = _data[6]&B00100000 ? 0:1;
                    w_MINUS = _data[6]&B00010000 ? 0:1;
                     w_HOME = _data[6]&B00001000 ? 0:1;
                     w_PLUS = _data[6]&B00000100 ? 0:1;
                        w_R = _data[6]&B00000010 ? 0:1;
                       w_LZ = _data[7]&B10000000 ? 0:1;
                        w_B = _data[7]&B01000000 ? 0:1;
                        w_Y = _data[7]&B00100000 ? 0:1;
                        w_A = _data[7]&B00010000 ? 0:1;
                        w_X = _data[7]&B00001000 ? 0:1;
                       w_RZ = _data[7]&B00000100 ? 0:1;
                     w_LEFT = _data[7]&B00000010 ? 0:1;
                       w_UP = _data[7]&B00000001 ? 0:1;
                }
            }

            if(old_connected == 0 && connected == 1){
                wait_ms(10);
                init_classic();
            }
            old_connected = connected;
}

void init_classic()
{
    i2c.frequency(100000);
    for(char t=0; t<6; t++){
      controllerType[t] = 0x00;
    }

    //if(!i2c.write(ADDRESS, NULL, 0)){

        char dat[] = {0xF0,0x55,0xFB,0x00,0xFE,0x03};
        i2c.write(ADDRESS, &dat[0], 2);
        i2c.stop();
        wait_ms(1);
        i2c.write(ADDRESS, &dat[2], 2);
        i2c.stop();
        wait_ms(1);
        i2c.write(ADDRESS, &dat[4], 2);
        i2c.stop();
        wait_ms(1);


        char cmd[] = {0xFA};
        i2c.write(ADDRESS, cmd, sizeof(cmd));
        wait_ms(1);
        if(i2c.read(ADDRESS, (char*)controllerType, 6)){
            connected = 0;
        }else{
            connected = 1;
        }
        i2c.stop();

        dataFormat = controllerType[4];
        checkController();

        /*
          Known data types
          1. Standard Wii Classic controller
          2. ?
          3. Classic controller, easier to read, not universally supported by 3rd part controllers
          4. Wii Motion Plus
        */
        //update_classic();
  //  }
}


int main () {
    game.begin();
    
    game.display.setFont(font3x5);
    game.display.setInvisibleColor(0);

    game.display.load565Palette(sprite_pal);
   
    while (game.isRunning()) {
        if (game.update()) {            
            
            
            updateClassic();


    //game.display.clear();
    char tempText[40];

    sprintf(tempText,"%03d\n%03d\n%03d\n%03d\n%03d\n%03d\n%03d\n%03d\n%03d\n \n%03d\n", connected, _data[0],_data[1],_data[2],_data[3],_data[4],_data[5],_data[6],_data[7],controllerType[4]);
    game.display.setCursor(0,0);
    game.display.print(tempText);
    sprintf(tempText,"%s\n",controller[controlType]);
    game.display.setCursor(0,120);
    game.display.print(tempText);
    

    char ox=8, oy=16;
    // draw background!
    for(char t=0; t<3; t++){
        game.display.drawBitmap(ox+24+t*16,oy+w_LT/60,sprite_buttons[12+t+(w_L*8)]);
        game.display.drawBitmap(ox+136+t*16,oy+w_RT/60,sprite_buttons[16+t+(w_R*8)]);
    }

    for(uint8_t y=0; y<12; y++){
        for(uint8_t x=0; x<25; x++){
            game.display.drawBitmap(ox+x*8,oy+y*8,sprites[sprite_map[x+25*y]]);
        }
    }

    game.display.drawBitmap(ox+64+(w_LX-127)/10,oy+56+(127-w_LY)/10,sprite_circle);
    game.display.drawBitmap(ox+120+(w_RX-127)/10,oy+56+(127-w_RY)/10,sprite_circle);
    if(w_RIGHT)game.display.drawBitmap(ox+45,oy+32, sprite_buttons[11]);
    if(w_DOWN)game.display.drawBitmap(ox+36,oy+41, sprite_buttons[9]);
    if(w_LEFT)game.display.drawBitmap(ox+27,oy+32, sprite_buttons[10]);
    if(w_UP)game.display.drawBitmap(ox+36,oy+23, sprite_buttons[8]);
    if(w_MINUS)game.display.drawBitmap(ox+80,oy+32,sprite_buttons[6]);
    if(w_HOME)game.display.drawBitmap(ox+96,oy+32,sprite_buttons[5]);
    if(w_PLUS)game.display.drawBitmap(ox+112,oy+32,sprite_buttons[6]);
    if(w_X)game.display.drawBitmap(ox+152,oy+16,sprite_buttons[0]);
    if(w_Y)game.display.drawBitmap(ox+136,oy+28,sprite_buttons[1]);
    if(w_A)game.display.drawBitmap(ox+168,oy+28,sprite_buttons[2]);
    if(w_B)game.display.drawBitmap(ox+152,oy+40,sprite_buttons[3]);
    if(w_LZ)game.display.drawBitmap(ox+77,oy+2,sprite_buttons[7]);
    if(w_RZ)game.display.drawBitmap(ox+110,oy+2,sprite_buttons[7]);




                
            } 
        }    
    
}