
#include "Pokitto.h"
Pokitto::Core mygame;

#include <stdint.h>

//Total colors 4
const uint16_t sprite_pal[] = {
59196,35953,14823,0,
};

const uint8_t sprite[] =
{
160,144,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,85,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,85,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,85,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,85,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,85,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,85,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,85,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,85,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,85,85,85,85,85,85,85,85,85,85,85,85,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,85,85,85,85,85,85,85,85,85,85,85,85,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,85,85,85,85,85,85,85,85,85,85,85,85,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,85,85,85,85,85,85,85,85,85,85,85,85,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,85,85,0,0,0,0,85,85,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,85,85,0,0,0,0,85,85,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,85,85,0,0,0,0,85,85,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,85,85,0,0,0,0,85,85,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,85,0,0,85,0,0,85,0,0,85,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,85,0,0,85,0,0,85,0,0,85,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,85,0,0,85,0,0,85,0,0,85,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,85,0,0,85,0,0,85,0,0,85,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,85,85,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,85,85,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,85,85,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,85,85,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,85,85,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,85,85,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,85,85,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,85,85,0,0,0,0,0,0,0,
0,0,0,0,0,0,85,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,85,0,0,0,0,0,0,
0,0,0,0,0,0,85,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,85,0,0,0,0,0,0,
0,0,0,0,0,0,85,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,85,0,0,0,0,0,0,
0,0,0,0,0,0,85,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,85,0,0,0,0,0,0,
0,0,0,0,0,0,85,0,0,85,170,170,170,85,0,0,85,0,0,0,0,0,0,85,0,0,85,170,170,170,85,0,0,85,0,0,0,0,0,0,
0,0,0,0,0,0,85,0,0,85,170,170,170,85,0,0,85,0,0,0,0,0,0,85,0,0,85,170,170,170,85,0,0,85,0,0,0,0,0,0,
0,0,0,0,0,0,85,0,0,85,170,170,170,85,0,0,85,0,0,0,0,0,0,85,0,0,85,170,170,170,85,0,0,85,0,0,0,0,0,0,
0,0,0,0,0,0,85,0,0,85,170,170,170,85,0,0,85,0,0,0,0,0,0,85,0,0,85,170,170,170,85,0,0,85,0,0,0,0,0,0,
0,0,0,0,0,0,0,85,85,85,170,170,170,85,0,0,0,85,85,85,85,85,85,0,0,0,85,170,170,170,85,85,85,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,85,85,85,170,170,170,85,0,0,0,85,85,85,85,85,85,0,0,0,85,170,170,170,85,85,85,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,85,85,85,170,170,170,85,0,0,0,85,85,85,85,85,85,0,0,0,85,170,170,170,85,85,85,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,85,85,85,170,170,170,85,0,0,0,85,85,85,85,85,85,0,0,0,85,170,170,170,85,85,85,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,0,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,85,85,85,85,85,85,85,85,85,85,85,85,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,85,85,85,85,85,85,85,85,85,85,85,85,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,85,85,85,85,85,85,85,85,85,85,85,85,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,85,85,85,85,85,85,85,85,85,85,85,85,85,85,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,85,85,170,170,170,170,170,170,170,170,170,85,85,85,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,85,85,170,170,170,170,170,170,170,170,170,85,85,85,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,85,85,170,170,170,170,170,170,170,170,170,85,85,85,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,85,85,170,170,170,170,170,170,170,170,170,85,85,85,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,85,85,170,170,170,170,170,170,170,170,170,85,85,85,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,85,85,170,170,170,170,170,170,170,170,170,85,85,85,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,85,85,170,170,170,170,170,170,170,170,170,85,85,85,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,85,85,170,170,170,170,170,170,170,170,170,85,85,85,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,85,85,85,85,85,85,170,170,170,85,85,85,170,85,85,85,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,85,85,85,85,85,85,170,170,170,85,85,85,170,85,85,85,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,85,85,85,85,85,85,170,170,170,85,85,85,170,85,85,85,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,85,85,85,85,85,85,170,170,170,85,85,85,170,85,85,85,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,85,85,85,85,85,85,170,170,170,85,85,85,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,85,85,85,85,85,85,170,170,170,85,85,85,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,85,85,85,85,85,85,170,170,170,85,85,85,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,85,85,85,85,85,85,170,170,170,85,85,85,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,85,85,170,170,170,170,170,85,85,85,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,85,85,170,170,170,170,170,85,85,85,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,85,85,170,170,170,170,170,85,85,85,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,85,85,170,170,170,170,170,85,85,85,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,85,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,85,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,85,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,85,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,85,85,170,170,170,170,170,170,85,85,85,170,170,170,170,170,170,170,85,85,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,85,85,170,170,170,170,170,170,85,85,85,170,170,170,170,170,170,170,85,85,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,85,85,170,170,170,170,170,170,85,85,85,170,170,170,170,170,170,170,85,85,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,85,85,170,170,170,170,170,170,85,85,85,170,170,170,170,170,170,170,85,85,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,170,170,170,170,170,170,170,170,170,170,170,170,170,170,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,0,0,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,85,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,85,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,85,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,85,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,85,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};




int px,py=0;

char respond[] = {0, 0};       //The 2 byte response we always get

DigitalInOut datClk(P0_11);
DigitalInOut datIn(P0_17);
DigitalInOut datOut(P0_13);

unsigned short checksum = 0;
int whichChar = 0;
bool isPrinter=0;

void sendByte(unsigned char byteToSend) {

    checksum += byteToSend;              //Always build this, even if not used
    for (int x = 0 ; x < 8 ; x++) {
        if (byteToSend & B10000000) {       
            datOut = 1; // data high
        } else {
            datOut = 0; // data low
        }
        datClk = 0; // clock low
        wait_us(55);
        datClk = 1; // clock high
        byteToSend <<= 1;
        wait_us(55);
    }
    datOut = 0; // test...
    wait_us(200);
}


void getResponse() {
    respond[0] = 0;
    respond[1] = 0;
    
    for (int xx = 0 ; xx < 2 ; xx++) {
        for (int x = 0 ; x < 8 ; x++) {
            respond[xx] <<= 1;              //Shift to the left making room for next bit. DO this first so we don't lose the last one
            datClk = 0;
            wait_us(25);
            if(datIn){
                respond[xx] |= 1;           //Set it       
            }
            wait_us(25);
            datClk = 1;
            wait_us(55);
        }
        wait_us(200);
    }
        wait_us(500);
}

void sendChecksum() {
    unsigned short lineChecksum = checksum; //Grab the state of checksum so we don't change it while sending
    sendByte(lineChecksum & 0xFF);          //Send checksum low byte
    sendByte(lineChecksum >> 8);            //Send checksum high byte
}

void sendHeader(){
    sendByte(0x88);    // magic
    sendByte(0x33);    // magic
    checksum = 0;       // reset checksum
}    

void initPrinter(){
    sendHeader();
    sendByte(0x01);    // 1 = init printer
    sendByte(0x00);    // compression, 0 = none, 1 = RLE
    sendByte(0x00);    // data length
    sendByte(0x00);    // data length 2nd byte
    sendChecksum();
    getResponse();
}

void printLine(){
    sendHeader();
    sendByte(0x04);    // 4 = Send some print data
    sendByte(0x00);    // compression, 0 = none, 1 = RLE
    // send 0x280 which is 640, the maximum data allowed at a time
    sendByte(0x80);    // data length
    sendByte(0x02);    // data length 2nd byte
    /*
    for(int t=0; t<640; t++){
        //sendByte(hadl[t]);    // test data
        sendByte(sprite[t+2]);    // test data
    }
    */

    int x1,y1,p1,p2,p3,p4,p5,p6,p7,p8,fullPixel;
    for(int line=0; line<2; line++){
        for(int block=0; block<20; block++){
            for(int row=0; row<8; row++){
                fullPixel = 0;
                x1 = px+(block*8);
                y1 = py+(line*8)+row;
                p1 = (mygame.display.getPixel(x1, y1)&2)>>1;
                p2 = (mygame.display.getPixel(x1+1, y1)&2)>>1;
                p3 = (mygame.display.getPixel(x1+2, y1)&2)>>1;
                p4 = (mygame.display.getPixel(x1+3, y1)&2)>>1;
                p5 = (mygame.display.getPixel(x1+4, y1)&2)>>1;
                p6 = (mygame.display.getPixel(x1+5, y1)&2)>>1;
                p7 = (mygame.display.getPixel(x1+6, y1)&2)>>1;
                p8 = (mygame.display.getPixel(x1+7, y1)&2)>>1;
                // getPixel is currently broken, so were-combine the pixels in a different order.
                fullPixel = (p4<<7)+(p3<<6)+(p2<<5)+(p1<<4)+(p8<<3)+(p7<<2)+(p6<<1)+p5;
                sendByte(fullPixel);

                p1 = mygame.display.getPixel(x1, y1)&1;
                p2 = mygame.display.getPixel(x1+1, y1)&1;
                p3 = mygame.display.getPixel(x1+2, y1)&1;
                p4 = mygame.display.getPixel(x1+3, y1)&1;
                p5 = mygame.display.getPixel(x1+4, y1)&1;
                p6 = mygame.display.getPixel(x1+5, y1)&1;
                p7 = mygame.display.getPixel(x1+6, y1)&1;
                p8 = mygame.display.getPixel(x1+7, y1)&1;
                fullPixel = (p4<<7)+(p3<<6)+(p2<<5)+(p1<<4)+(p8<<3)+(p7<<2)+(p6<<1)+p5;

                sendByte(fullPixel);
            }
        }
    }

    sendChecksum();
    getResponse();
    // end data statement
    sendHeader();
    sendByte(0x04);    // 
    sendByte(0x00);    // 
    sendByte(0x00);    // 
    sendByte(0x00);    // 
    sendChecksum();
    getResponse();

    sendByte(0x88); // Magic bytes
    sendByte(0x33);
    checksum = 0;
    sendByte(0x02); // Commande 2 (Print)
    sendByte(0x00);
    sendByte(0x04); // 4 bytes to send
    sendByte(0x00);
    sendByte(0x01); // 1 = print, 0 = line feed
    if(py/16==8){
        sendByte(0x03); // Marges (nibbles avant 1, après 3)
    }else{
        sendByte(0x00); // Marges (nibbles avant 1, après 3)
    }        
    sendByte(0xE4); // Palette (11100100: Noir, Foncé, Clair, Blanc)
    sendByte(0x40); // Expo (7 bits)

    sendChecksum();
    getResponse();

}


int main () {
    mygame.begin();

    datClk.output(); // clock to output
    datOut.output(); // data out to output
    datIn.input(); // data In to input
    datIn.mode(PullUp);
    
    datClk = 1; // start clock line high
    datOut = 0; // start data low


    //wait(5); // hang on a little

    //printShape(1); // test!

    mygame.display.persistence = 1;
//    mygame.display.clear();
//    mygame.display.print("Printer Test\n");

    mygame.display.drawBitmap(0,0,sprite);
    mygame.display.load565Palette(sprite_pal);


    while (mygame.isRunning()) {
        if (mygame.update()) {
            
            if (mygame.buttons.bBtn()){
                mygame.display.drawBitmap(0,0,sprite);
                py=0;
            }            
                        
            if (mygame.buttons.aBtn()){
                initPrinter();
                py=0;
                if(respond[0]==0x81 && respond[1]==0x00){
                    isPrinter=1;
                }
    
                
                if(isPrinter){
                    int t=0;
                    while(t<9){
                        
                        wait_ms(300);
                        sendByte(0x88);    // magic
                        sendByte(0x33);    // magic
                        checksum = 0;
                        sendByte(0x0F);    // 
                        sendByte(0x00);    // 
                        sendByte(0x00);    // 
                        sendByte(0x00);    // 
                        sendChecksum();
                        getResponse();
                            
                        if(!(respond[1]&0x0B)){
                            printLine();
                            py+=16;
                            t++;
                        }
                    } // t
                    
                    
                    
                    
                }else{
                    // show error log here
                    if(respond[0] != 0x81){
                        mygame.display.print("Not Printer\n");
                    }else{
                        mygame.display.print("Printer Error\n");
                    }
                }
                
//                wait(1);
            }
        } 
    }    
    
}