#include "mbed.h"
#include "Encoder.h"

//STM mbed bug: these macros are MISSING from stm32f3xx_hal_tim.h
#ifdef TARGET_STM32F3
#define __HAL_TIM_GET_COUNTER(__HANDLE__) ((__HANDLE__)->Instance->CNT)
#define __HAL_TIM_IS_TIM_COUNTING_DOWN(__HANDLE__)            (((__HANDLE__)->Instance->CR1 &(TIM_CR1_DIR)) == (TIM_CR1_DIR))
#endif

// For encoder
TIM_Encoder_InitTypeDef encoder2, encoder3;
TIM_HandleTypeDef   timer2, timer3;

//For usb port serial 
Serial pc(USBTX, USBRX);
//Led on F4446RE
DigitalOut  my_led(LED1);
// Blue button on F446RE
InterruptIn my_button(USER_BUTTON);

// For PWM for control DC-motor
PwmOut      motor_R(D2);
DigitalOut  motor_R_dir(D3);
PwmOut      motor_L(D7);
DigitalOut  motor_L_dir(D6);

void pressed() {
    // Event handler, pressed blue button 
    // Reverse direction of motor 
    motor_R_dir = !motor_R_dir;
    motor_L_dir = !motor_L_dir;
}

int main()
{
    motor_R_dir = 0;
    motor_L_dir = 0;
    // Set PWM
    motor_R.period_ms(10);
    motor_L.period_ms(10);
    
    // Set button
    my_button.fall(&pressed); // falling trigger

    pc.baud (115200); // USB port baud rate
    
    //counting on both A&B inputs, 4 ticks per cycle, full 32-bit count
    EncoderInit(&encoder2, &timer2, TIM2, 0xffffffff, TIM_ENCODERMODE_TI12);//PA0 PA1 = Nucleo A0 A1 // right motor encoder

    //counting on both A&B inputs, 4 ticks per cycle, full 32-bit count
    EncoderInit(&encoder3, &timer3, TIM3, 0xffffffff, TIM_ENCODERMODE_TI12);//PB4 PB5 = Nucleo D5 D4// left motor encoder
    
    while (1) {
        uint32_t en_count_R=0, en_count_L=0;
        int8_t en_dir_R, en_dir_L;
        
        //OK 401 411 446 NOK 030
        //count2=TIM2->CNT;
        //dir2=TIM2->CR1&TIM_CR1_DIR;
        en_count_R=__HAL_TIM_GET_COUNTER(&timer2);
        en_dir_R = __HAL_TIM_IS_TIM_COUNTING_DOWN(&timer2);

        //OK 401 411 446 030
        //count3=TIM3->CNT;
        //dir3=TIM3->CR1&TIM_CR1_DIR;
        en_count_L=__HAL_TIM_GET_COUNTER(&timer3);
        en_dir_L = __HAL_TIM_IS_TIM_COUNTING_DOWN(&timer3);
        
        printf("%d%s %d%s \r\n", en_count_R, en_dir_R==0 ? "+":"-",en_count_L, en_dir_L==0 ? "+":"-");
        
        // Controll motor                                      
        motor_R.write(0.1); // duty time 10%
        motor_L.write(0.1);
        my_led = !my_led; // blink LED on STM
        wait(0.01); // 10 ms
    }
}
