#include "mbed.h"
#include "SLCD.h"
#include "TSISensor.h"


#define CHANNELON   0
#define CHANNELOFF  1
#define LCDLEN      10
#define DATATIME    100 //milli seccnds
//LCD messages

#define TONEARRAY 

// Operating parameters
#define SIDETONE    700.0   
#define TONEMIN     200.0
#define TONEINT     800.00 // So tone max is 1000
#define TONEON      0.50
#define TONEOFF     0.0
#define SPEEDAST    0
#define TONEAST     1
#define NUMTONES    10
#define LEDPERIOD   0.001
//#define PRINTDEBUG

Serial pc(USBTX, USBRX);

float diatonicScale[NUMTONES] = {246.94, 261.63,293.66,329.63,349.23,392.00,440.00,493.88,523.25,587.33};
float diatonicScaleOctave[NUMTONES] = {659.25, 698.46, 783.99, 880.00, 987.77, 1046.50, 1174.66, 1318.51, 1396.91, 1567.98 };
SLCD slcd; //define LCD display

TSISensor tsiScaling; // Capacitive sensor/slider

InterruptIn mybutton(PTC3);  //push botton with internal pullup. decide which diatonicScale id called. use the right button (why (PTC3))
PwmOut led(LED_RED);
DigitalOut outPin(PTC9); //J1-16
PwmOut soundOut(PTA13);
Timer dataTimer;
// Global scalars
char lcdData[LCDLEN];

float tonePeriod;
float toneFreq = SIDETONE;

// Int used to switch between different octave. Channeloff is equal one.
//relayState takes two integers; 1 or 0 
int relayState = CHANNELOFF;


void pressed() // calls button intterupt line 34
{
    relayState = !relayState; //swicthes between 0 and 1. depends on which state is relayState. if it's one, when the the right button is presses
    //if changes to zero. if it's zero, it changes to one.
}

void LCDMessNoDwell(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 
  
void diatonicAdjust( float scaling) {
    int tempInt;
    int scaleIndex;
    static int oldScaleIndex = 0;
/* There appears to be a set up time for setting the PWM time period
only do a nes set up if the indext changes.
*/
    scaleIndex = (int)(NUMTONES * scaling);
    if (scaleIndex != oldScaleIndex) {
        if (relayState == CHANNELOFF)
            toneFreq = diatonicScale[scaleIndex];
        else 
            toneFreq = diatonicScaleOctave[scaleIndex];
        tonePeriod = 1.0/toneFreq;  
        soundOut.period(tonePeriod); // adjusting period
        soundOut.write(TONEON); // there is a setup time for both period and DF
        oldScaleIndex = scaleIndex;
    } else {
        return;
    }
#ifdef PRINTDEBUG
    pc.printf(" %f,%d\n\r",scaling, scaleIndex );
#endif
    tempInt = (int)toneFreq;
    sprintf (lcdData,"%4d",tempInt);
    LCDMessNoDwell(lcdData);
    return;
}



void lightAdjust( float scaling) { // Control brightness of LED
    float tempDutyFactor;
    
    tempDutyFactor = 1.0 - scaling; //LED is a sinking connection                                   // anode is held at 5V
    led.write(tempDutyFactor); //adjusting duty factor
    return;
}

int main(){
    int tempInt;
    float tempValue;    
    tonePeriod = 1.0/toneFreq; 
    soundOut.period(tonePeriod);
    led.period(tonePeriod);
    led.write(CHANNELOFF);
    outPin.write(CHANNELOFF);
    // set up interrrupts to be used later for taps
    mybutton.fall(&pressed);
    
    tempInt = (int)toneFreq;
    sprintf (lcdData,"%4d",tempInt);
    LCDMessNoDwell(lcdData);
   // Start data timer
    dataTimer.start();
    dataTimer.reset(); 
     
    while (true) {
        if (dataTimer.read_ms() > DATATIME){ // check to see if enough time has passed
                                            // to read the touch pad
            tempValue = tsiScaling.readPercentage();
            if(tempValue > 0) {
                // soundOut.write(TONEON); // set duty factor to 50%
                diatonicAdjust(tempValue);
                lightAdjust(tempValue);
            } else { 
                soundOut.write(TONEOFF); // set dutyfactor to 0%
                LCDMessNoDwell("SOFF");
            }       
            dataTimer.reset();
        }                 
    } // while forever
}// end main