#include "mbed.h"
#include "MMA8451Q8.h"
#include "SLCD.h"
/* 
Test of the accelerometer, digital I/O, on-board LCD screen, and 16-bit ADC.
 Looing at vector product of the x-y components of the accelerometer.
 Works pretty well. Still rough, program wise - sc 140710
 Addiing touch sensor to replace potentiometer.
 Show x and y components 
 */

#define BLINKTIME 0.7
#define DATATIME 0.5
#define DATADISPDWELL 0.2
#define NUMLEDS 2
#define LEDON 0
#define LEDOFF 1
#define SCALING 13
#define LCDLEN 10
#define RSTARTMESS "PNCH"
#define MAXVECT "MAXV"
#define XCOMP "XCMP"
#define YCOMP "YCMP"
#define ZCOMP "ZCMP"
#define ANALTOVOLTS 3.3
#define LEDDELAY 0.400
//define states
#define NUMSTATES 4
#define XCOMPD 0
#define YCOMPD 1
#define ZCOMPD 2
#define VMAXD 3
#define MAXGS 8
#define COUNTSCALE 1
#define REG_WHO_AM_I      0x0D
#define XYZ_DATA_CFG      0x0E

#define REG_OUT_X_MSB     0x01
#define REG_OUT_Y_MSB     0x03
#define REG_OUT_Z_MSB     0x05

#define MAX_2G            0x00
#define MAX_4G            0x01
#define MAX_8G            0x02


#define PROGNAME "LCD_punch_mtr 8 v5\r/n"
#define LCDNAME "PC.V5"


//#define PRINTDBUG
// Accelerometer SPI pins
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

SLCD slcd; //define LCD display
Timer blinkTimer;
Timer dataTimer;
Timer displayTimer;
MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
AnalogIn TMP01(PTB1);
DigitalOut LEDs[NUMLEDS]={LED_RED, LED_GREEN}; //Indicator LEDs
Serial pc(USBTX, USBRX);
char displayTitles[NUMSTATES][LCDLEN] = {XCOMP,YCOMP,ZCOMP,MAXVECT};
float accaxisdata[NUMSTATES];
char displayformats[NUMSTATES][LCDLEN] = {"%4.0f","y.%3.2f","z.%3.2f","v.%3.2f"};

void LCDMess(char *lMess, float dWait){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
        wait(dWait);
} 
void LCDMessNoDwell(char *lMess){
        slcd.Home();
        slcd.clear();
        slcd.printf(lMess);
} 


void allLEDsOFF(int numberOfLEDS) {
    int i;
    for (i=0;i<numberOfLEDS; i++){
            LEDs[i] = LEDOFF;
        }

}

void runLEDs(int numberOfLEDS) {
    int i;
    for (i=0;i<numberOfLEDS; i++){
            LEDs[i] = LEDON;
            wait(0.2);
        }
   allLEDsOFF(numberOfLEDS);     
}



int main() {
    
    int RButtonState;
    int LButtonState;
    DigitalIn RtButton(PTC12);
    DigitalIn LftButton(PTC3);
    int displayState = XCOMPD; 
    float xAcc = 0.0;
    float yAcc = 0.0;
    float zAcc = 0.0;
    float previous_xAcc = 0.0;
    float xAccDiff = 0.0;
    int xcounter = 0;
    float previous_yAcc = 0.0;
    float yAccDiff = 0.0;
    int ycounter = 0;
    float previous_zAcc = 0.0;
    float zAccDiff = 0.0;
    int zcounter = 0;
    float vector;
    float vMax = 0.0;
    float DisplayTime = DATADISPDWELL;
    float LEDDwell = BLINKTIME;
    int outState = false;
    char lcdData[LCDLEN]; //buffer needs places dor decimal pt and colon
    uint8_t regData = MAX_4G; // test value must change after G setting
    
#ifdef PRINTDBUG
        pc.printf(PROGNAME);
#endif
    LCDMess(LCDNAME, BLINKTIME);
// Initialze readings and sequence the LED's for dramtic effect.
    allLEDsOFF(NUMLEDS);
    blinkTimer.start();
    blinkTimer.reset();
    displayTimer.start();
    displayTimer.reset();
    dataTimer.start();
    dataTimer.reset();
    LCDMess(RSTARTMESS, BLINKTIME);
// Go into registers ofn Accelerometer, change sensitivity then test.
// http://cache.freescale.com/files/sensors/doc/data_sheet/MMA8451Q.pdf
// See page 26
// Set 2 g max limit ****************** Note limits
    acc.setGLimit(MAX_4G); // For now set to 2g
    acc.readRegs(XYZ_DATA_CFG, &regData, 1);
    sprintf (lcdData,"%d",regData);
    LCDMess(lcdData,BLINKTIME);
    acc.readRegs(REG_WHO_AM_I, &regData, 1);
    sprintf (lcdData,"%d",regData);
    LCDMess(lcdData,BLINKTIME);   
// main loop forever 
    while(true) {

// Handle user input for display selections
        RButtonState = !RtButton; // button is pulled up so false is when button is pushed it's inverted to avoid confusion downstream
        if (RButtonState){
            vMax = 0.0; // Clear vMax
            LCDMess(RSTARTMESS, BLINKTIME);
        }
        LButtonState = !LftButton;
        if (LButtonState) {  //Change data that is displayed
            displayState = (displayState + 1) % NUMSTATES;
            // Change to switch/case soon.
            LCDMess(displayTitles[displayState],BLINKTIME);     
        }
    
// --------------------------------------------
        while (dataTimer.read() > DATATIME){

// No offset
            xAcc = (acc.getAccX());
            xCounts = acc.getAccAxis(REG_OUT_X_MSB);
            yAcc = (acc.getAccY());
            yCounts = acc.getAccAxis(REG_OUT_Y_MSB);
            zAcc = (acc.getAccZ());
            zCounts = acc.getAccAxis(REG_OUT_Z_MSB);
            
            
            //xsteps
            xAccDiff = abs(previous_xAcc - xAcc);
            if (xAccDiff > 0.02){
                xcounter++;                
            };
            
            //ysteps
            yAccDiff = abs(previous_yAcc - yAcc);
            if (yAccDiff > 0.03){
                ycounter++;                
            };
            
            //zsteps
            zAccDiff = abs(previous_zAcc - zAcc);
            if (zAccDiff > 0.01){
                zcounter++;                
            };
            
            previous_xAcc = xAcc;
            previous_yAcc = yAcc;
            previous_zAcc = zAcc;
            printf("%1.2f    %1.2f   %1.2f   %1.2f   %d   %1.2f   %d   %1.2f   %d\n", xAcc, yAcc, zAcc, xAccDiff, xcounter, yAccDiff,  ycounter, zAccDiff,  zcounter);
           
//Prepare data for LCD display 
            accaxisdata[XCOMPD] = abs((float)xcounter/COUNTSCALE); // scalling is set to 1 at this point
            accaxisdata[YCOMPD] = abs((float)ycounter/COUNTSCALE);
            accaxisdata[ZCOMPD] = abs((float)zcounter/COUNTSCALE);
            
            
            accaxisdata[VMAXD] = vMax;
            dataTimer.reset();
            LEDDwell = 1.1 - vMax/MAXGS;
        }

// Display the appropriate data on the LCD based upon what mode was chosen
        while (displayTimer.read() > DisplayTime){
            sprintf (lcdData,displayformats[displayState],accaxisdata[displayState]);          
            LCDMessNoDwell(lcdData);
            displayTimer.reset();
        } // displaytimer 
// Wait then do the whole thing again.  
// Alive LEDs
        while(blinkTimer.read()> LEDDwell) {     
            LEDs[0].write(outState);
            LEDs[1].write(!outState);
            outState = !outState; 
            blinkTimer.reset();
        } 
    }//forever loop
}// main
