#include "mbed.h"
#include "rtos.h"
#include "Timer.h"
#include "C12832.h"
#include "stdio.h"
#include "stdlib.h"
// Samuel Pearson 19064819
// Joystick push kills LED bit on left, if it is on
// If bit is not on, another is created
// Goal is to kill off all of the bits
// LEDs flash and speaker beeps on a win

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
DigitalIn pb(p14);        //the player hits the switch connected here to respond
PwmOut spkr(p26);
PwmOut RGBLED_r(p23);
PwmOut RGBLED_g(p24);
PwmOut RGBLED_b(p25);
C12832 lcd(p5, p7, p6, p8, p11);  

// mutex to make the lcd lib thread safe
Mutex lcd_mutex;
Mutex mtx;

Timer t1, t2;                  //used to measure the response time
int player1, player2, player2Ready, StartGame, GameFinished = 0;
float Player1Time, Player2Time = 0;

void display(int number)
{
    myled1 = (number) & 0x01;
    myled2 = (number>>1) & 0x01;
    myled3 = (number>>2) & 0x01;
    myled4 = (number>>3) & 0x01;
}

void measure (int value)                 // calls when the joystick is pressed
{         
  if (pb)
  {                            //Check if button is held
    lcd_mutex.lock();
    lcd.cls();
    lcd.printf("Button Press!\n");
    lcd_mutex.unlock();
  }
}

void calculate (float T1, float T2)
{
    mtx.lock();
    if (T1 < T2)
    {
        lcd.printf("Player 1 Wins!!\n");
    }
    if (T1 > T2)
    {
        lcd.printf("Player 2 Wins!\n");
    }
    if (T1 == T2)
    {
        lcd.printf("Game was a Draw, Try Again\n");
    }
    mtx.unlock();
}

void thread3(void const *args)
{
    while(true) // thread loop
    {         
        RGBLED_r = 0.7 + (rand() % 11)/20.0;
        RGBLED_g = 0.7 + (rand() % 11)/20.0;
        RGBLED_b = 0.7 + (rand() % 11)/20.0;
        Thread::wait(1667);    // wait 1.5s
    }
}

int main()
{
    while(1)
    {
    Thread t3(thread3); //RGB LED
    lcd.printf("Destroy the Bit - \n\r");
    lcd.printf("Player 1 Start\n\r");
    lcd.printf("Press Joystick to Start\n\r");
    unsigned int value = 0x12;
    spkr.period(1.0/2000.0);
    while (StartGame == 0)
    {
        if (pb)
        {
            StartGame = 1;
            player2 = 1;
            player1 = 0;
            t1.start();
            t2.start();
        }
    }
    while(StartGame == 1) 
    {
        if (player1 == 0)
        {
            lcd.cls();
            lcd.printf("Press Joystick to kill bit\n\r");
            value = value ^ pb;
            if (value == 0) {
                for (int i=0; i<5; ++i) {
                spkr = 0.5;
                lcd.cls();
                display(0x0F);
                wait(.5);
                display(0);
                spkr = 0.0;
                wait(.25);
            }
            t1.stop();
            value = 0x012;
            lcd_mutex.lock();
            lcd.printf("Player 1 Finished!!!!!!!\n\r");
            lcd.printf("Finish time - %f secs\n\r", t1.read());
            wait(2);
            lcd_mutex.unlock();
            Player1Time = t1.read();
            player1 = 1;
            player2 = 0;
            t1.reset();
            t2.reset();
        }
        value = ((value & 0x01)<<3) | value >> 1;
        display(value);
        measure(value);
        wait(.25);
        }            
        if (player2 == 0)
        {
            if (player2Ready == 0)
            {
            lcd.cls();
            lcd.printf("Player 2 Start\n\r");
            lcd.printf("Press JoyStick to Start\n\r");
            }
            while(player2Ready == 0)
            {
                if (pb)
            {
                t2.start();
                player2Ready = 1;
                }
            }
            lcd.cls();
            lcd.printf("Press Joystick to kill bit\n\r");
            value = value ^ pb;
            if (value == 0) {
                for (int i=0; i<5; ++i) {
                spkr = 0.5;
                display(0x0F);
                wait(.5);
                display(0);
                spkr = 0.0;
                wait(.25);
            }
            t2.stop();
            value = 0x012;
            lcd_mutex.lock();
            lcd.printf("Player 2 Finished!!!!!!!\n\r");
            lcd.printf("Finish time - %f secs\n\r", t2.read());
            wait(2);
            lcd_mutex.unlock();
            Player2Time = t2.read();
            player2 = 1;
            StartGame = 0;
            GameFinished = 1;
            t2.reset();
        }
        value = ((value & 0x01)<<3) | value >> 1;
        display(value);
        measure(value);
        wait(.25);
        }
    }
if (GameFinished == 1)
{
    lcd.cls();
    wait(1);
    lcd.printf("Game has Ended\n");
    calculate(Player1Time, Player2Time);
    wait(1);
    lcd.cls();
    lcd.printf("Game will reset in 5 secs\n");
    wait(5);
    GameFinished = 0;
    Player1Time, Player2Time = 0;
    lcd.cls();
    }
}
}