#include "mbed.h"
#include "H3LIS331DL.h"
#include "C12832.h"

//please get these value by running H3LIS331DL_AdjVal
#define VAL_X_AXIS  128
#define VAL_Y_AXIS  61
#define VAL_Z_AXIS  303

H3LIS331DL h3lis(p28, p27);
Serial pc(USBTX, USBRX); // tx, rx
C12832 lcd(p5, p7, p6, p8, p11);

int main() {
    h3lis.init();
    h3lis.importPara(VAL_X_AXIS,VAL_Y_AXIS,VAL_Z_AXIS);

    while(1) {
        double accel[3] = {0.0, 0.0, 0.0};
        
        h3lis.getAcceleration(accel);
        pc.printf("X %1.3f    Y %1.3f    Z %1.3f\n", accel[0], accel[1], accel[2]);
        lcd.printf("X %1.3f Y %1.3f Z %1.3f   ", accel[0], accel[1], accel[2]);
        lcd.locate(0,0);
        wait_ms(100);
    }
}
