#include "mbed.h"
#include "H3LIS331DL.h"

H3LIS331DL h3lis(p28, p27);

Serial pc(USBTX, USBRX); // tx, rx

char* tag[] = {"Z+","Z-","Y+","Y-","X+","X-"};
int16_t dataBuf[6][3] = {0};

void getAdjParameter()
{
    AxesRaw_t data;
    int32_t sum[3] = {0};
    
    pc.printf("Start ...\n");
    wait(3);
    for(int timer = 0; timer < 6; timer++){
      pc.printf("please turn ");
      pc.printf("%s", tag[timer]);
      pc.printf(" up\n");
      wait(3);
      for(int i = 0; i < 5; i++){
        pc.printf("start will be in ");
        pc.printf("%i", 5 - i);
        pc.printf(" seconds\n");
        wait(1);
      }
      pc.printf("calculating ... ");
      for(int i = 0 ; i < 100; i++){
        status_t response = h3lis.getAccAxesRaw(&data);
        if(MEMS_SUCCESS == response){
          sum[0] += data.AXIS_X;
          sum[1] += data.AXIS_Y;
          sum[2] += data.AXIS_Z;
        }
        wait_ms(20);
     }
     dataBuf[timer][0] = sum[0]/100;
     dataBuf[timer][1] = sum[1]/100;
     dataBuf[timer][2] = sum[2]/100;
     sum[0] = sum[1] = sum[2] = 0;
     pc.printf("calculate success\n");
     wait(1);
   }
   int16_t axis_x = (dataBuf[4][0] + dataBuf[5][0])*0.3 + (dataBuf[0][0]+dataBuf[1][0]+dataBuf[2][0]+dataBuf[3][0])/10;   
   pc.printf("adjust value of X axis is %d\n", axis_x);
   
   int16_t axis_y = (dataBuf[2][1] + dataBuf[3][1])*0.3 + (dataBuf[0][1]+dataBuf[1][1]+dataBuf[4][1]+dataBuf[5][1])/10;
   pc.printf("adjust value of Y axis is %d\n", axis_y);
   
   int16_t axis_z = (dataBuf[0][2] + dataBuf[1][2])*0.3 + (dataBuf[2][2]+dataBuf[3][2]+dataBuf[4][2]+dataBuf[5][2])/10;
   pc.printf("adjust value of Z axis is %d\n", axis_z);
   
   pc.printf("note: these data can be used in H3LISDL_Demo sketch");
}

int main() {
    h3lis.init();

    getAdjParameter();
    while(1) {
        wait(1);
    }
}
